/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.processor;

import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.processor.FieldProcessor;

public class PercentageFloatFieldProcessor
implements FieldProcessor<Double> {
    private final boolean pre;
    private final String symbol;
    private final FieldProcessor<Double> numberProcessor;
    private final String nullValue;

    public PercentageFloatFieldProcessor(boolean pre, String symbol, FieldProcessor<Double> numberProcessor, String nullValue) {
        this.pre = pre;
        this.symbol = symbol;
        this.numberProcessor = numberProcessor;
        this.nullValue = nullValue;
    }

    @Override
    public Double toObject(String text) throws MetaCSVReadException {
        if (text == null || text.equals(this.nullValue)) {
            return null;
        }
        text = Util.cleanCurrencyText(text, this.pre, this.symbol);
        return this.numberProcessor.toObject(text) / 100.0;
    }

    @Override
    public String toString(Double value) {
        if (value == null) {
            return this.nullValue;
        }
        String valueAsString = this.numberProcessor.toString(value * 100.0);
        if (this.pre) {
            return this.symbol + valueAsString;
        }
        return valueAsString + this.symbol;
    }

    @Override
    public String toCanonicalString(String text) throws MetaCSVReadException {
        Double value = this.toObject(text);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    @Override
    public Double cast(Object o) {
        return this.numberProcessor.cast(o);
    }
}

