/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.processor;

import com.github.jferard.javamcsv.OnError;
import com.github.jferard.javamcsv.description.FieldDescription;
import com.github.jferard.javamcsv.description.TextFieldDescription;
import com.github.jferard.javamcsv.processor.FieldProcessorFactory;
import com.github.jferard.javamcsv.processor.WriteFieldProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WriteProcessorProvider {
    private final Map<Integer, FieldDescription<?>> descriptionByColIndex;
    private final String nullValue;
    private final OnError onError;
    private final FieldProcessorFactory fieldProcessorFactory;
    private final List<WriteFieldProcessor> processors;

    public WriteProcessorProvider(Map<Integer, FieldDescription<?>> descriptionByColIndex, String nullValue, OnError onError) {
        this.descriptionByColIndex = descriptionByColIndex;
        this.nullValue = nullValue;
        this.onError = onError;
        this.fieldProcessorFactory = new FieldProcessorFactory();
        this.processors = new ArrayList<WriteFieldProcessor>();
    }

    public WriteFieldProcessor getProcessor(int c) {
        while (c >= this.processors.size()) {
            this.processors.add(null);
        }
        WriteFieldProcessor processor = this.processors.get(c);
        if (processor == null) {
            processor = this.createProcessor(c);
            this.processors.set(c, processor);
        }
        return processor;
    }

    private WriteFieldProcessor createProcessor(int c) {
        FieldDescription<Object> fieldDescription = this.descriptionByColIndex.get(c);
        if (fieldDescription == null) {
            fieldDescription = TextFieldDescription.INSTANCE;
        }
        return this.fieldProcessorFactory.toWriteFieldProcessor(fieldDescription, this.nullValue, this.onError, true);
    }
}

