/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.jena;

import com.github.jsonldjava.jena.JenaJSONLD;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JenaJSONReaderTest {
    @BeforeClass
    public static void init() {
        JenaJSONLD.init();
    }

    @Test
    public void readInputStream() throws Exception {
        Model model = ModelFactory.createDefaultModel();
        String jsonld = " { '@id': 'test', \n   'http://example.com/value': 'Test' \n }  ";
        jsonld = jsonld.replace('\'', '\"');
        ByteArrayInputStream in = new ByteArrayInputStream(jsonld.getBytes("utf8"));
        String baseUri = "http://example.com/";
        model.read((InputStream)in, "http://example.com/", "JSON-LD");
        this.checkRelative(model);
    }

    private void checkRelative(Model model) {
        Assert.assertEquals((long)1L, (long)model.size());
        Statement statement = (Statement)model.listStatements().next();
        Assert.assertEquals((Object)"http://example.com/value", (Object)statement.getPredicate().toString());
        Assert.assertEquals((Object)"Test", (Object)statement.getString());
        Assert.assertEquals((Object)"http://example.com/test", (Object)statement.getSubject().toString());
    }

    @Test
    public void readURL() throws Exception {
        Model model = ModelFactory.createDefaultModel();
        String url = this.getClass().getResource("../jena/relative.jsonld").toExternalForm();
        String baseUri = "http://example.com/";
        model.read(url, "http://example.com/", "JSON-LD");
        model.write((OutputStream)System.out, "TURTLE", "");
        this.checkRelative(model);
    }
}

