/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.jena;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.utils.JsonUtils;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Context;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.SyntaxLabels;

public class JsonLDReader
implements ReaderRIOT {
    private final LabelToNode labels = SyntaxLabels.createLabelToNode();
    public static String LITERAL = "literal";
    public static String BLANK_NODE = "blank node";
    public static String IRI = "IRI";

    public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context) {
        this.read(new InputStreamReader(in, Charset.forName("UTF-8")), baseURI, ct, output, context);
    }

    public void read(Reader in, String baseURI, ContentType ct, final StreamRDF output, Context context) {
        try {
            JsonLdTripleCallback callback = new JsonLdTripleCallback(){

                public Object call(RDFDataset dataset) {
                    for (String gn : dataset.keySet()) {
                        Object x = dataset.get((Object)gn);
                        if ("@default".equals(gn)) {
                            List triples = (List)x;
                            for (Map t : triples) {
                                Node s = JsonLDReader.this.createNode(t, "subject");
                                Node p = JsonLDReader.this.createNode(t, "predicate");
                                Node o = JsonLDReader.this.createNode(t, "object");
                                Triple triple = Triple.create((Node)s, (Node)p, (Node)o);
                                output.triple(triple);
                            }
                            continue;
                        }
                        List quads = (List)x;
                        Node g = NodeFactory.createURI((String)gn);
                        for (Map q : quads) {
                            Node s = JsonLDReader.this.createNode(q, "subject");
                            Node p = JsonLDReader.this.createNode(q, "predicate");
                            Node o = JsonLDReader.this.createNode(q, "object");
                            output.quad(Quad.create((Node)g, (Node)s, (Node)p, (Node)o));
                        }
                    }
                    return null;
                }
            };
            JsonLdOptions options = new JsonLdOptions(baseURI);
            options.useNamespaces = true;
            JsonLdProcessor.toRDF((Object)JsonUtils.fromReader((Reader)in), (JsonLdTripleCallback)callback, (JsonLdOptions)options);
        }
        catch (IOException e) {
            throw new RiotException("Could not read JSONLD: " + e, (Throwable)e);
        }
        catch (JsonLdError e) {
            throw new RiotException("Could not read JSONLD: " + (Object)((Object)e), (Throwable)e);
        }
    }

    private Node createNode(Map<String, Object> tripleMap, String key) {
        Map x = (Map)tripleMap.get(key);
        return this.createNode(x);
    }

    private Node createNode(Map<String, Object> map) {
        String type = (String)map.get("type");
        String lex = (String)map.get("value");
        if (type.equals(IRI)) {
            return NodeFactory.createURI((String)lex);
        }
        if (type.equals(BLANK_NODE)) {
            return (Node)this.labels.get(null, (Object)lex);
        }
        if (type.equals(LITERAL)) {
            String lang = (String)map.get("language");
            String datatype = (String)map.get("datatype");
            if (lang == null && datatype == null) {
                return NodeFactory.createLiteral((String)lex);
            }
            if (lang != null) {
                return NodeFactory.createLiteral((String)lex, (String)lang, null);
            }
            RDFDatatype dt = NodeFactory.getType((String)datatype);
            return NodeFactory.createLiteral((String)lex, (RDFDatatype)dt);
        }
        throw new InternalErrorException("Node is not a IRI, bNode or a literal: " + type);
    }
}

