/*
 * Decompiled with CFR 0.152.
 */
package com.github.jyane.grpc.annotations.checkers;

import com.google.common.base.Preconditions;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;

abstract class AnnotationChecker
extends BugChecker
implements BugChecker.IdentifierTreeMatcher,
BugChecker.MemberSelectTreeMatcher,
BugChecker.CompilationUnitTreeMatcher {
    private boolean shouldBeChecked = false;
    private final String annotationType;
    private final String basePackage;

    AnnotationChecker(String basePackage, String annotationType) {
        this.annotationType = (String)Preconditions.checkNotNull((Object)annotationType, (Object)"annotationType");
        this.basePackage = (String)Preconditions.checkNotNull((Object)basePackage, (Object)"packageName");
    }

    private Optional<AnnotationMirror> findAnnotatedApi(Symbol symbol) {
        if (symbol == null) {
            return Optional.empty();
        }
        for (AnnotationMirror annotation : symbol.getAnnotationMirrors()) {
            if (!annotation.getAnnotationType().toString().equals(this.annotationType)) continue;
            return Optional.of(annotation);
        }
        return this.findAnnotatedApi(symbol.owner);
    }

    private Description match(Tree tree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (!this.shouldBeChecked || symbol == null) {
            return Description.NO_MATCH;
        }
        return this.findAnnotatedApi(symbol).map(x -> this.describe(tree, (AnnotationMirror)x)).orElse(Description.NO_MATCH);
    }

    protected abstract Description describe(Tree var1, AnnotationMirror var2);

    public Description matchIdentifier(IdentifierTree tree, VisitorState state) {
        return this.match(tree, state);
    }

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        return this.match(tree, state);
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        ExpressionTree packageName = tree.getPackageName();
        if (packageName == null) {
            return Description.NO_MATCH;
        }
        String name = packageName.toString();
        if (!name.equals(this.basePackage) && !name.startsWith(this.basePackage + ".")) {
            this.shouldBeChecked = true;
        }
        return Description.NO_MATCH;
    }
}

