/*
 * Decompiled with CFR 0.152.
 */
package com.github.krenfro.sendgrid.asm;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.krenfro.sendgrid.asm.Group;
import com.github.krenfro.sendgrid.asm.SendGrid;
import com.github.krenfro.sendgrid.asm.Suppression;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;

public class SuppressionManager
extends SendGrid {
    public SuppressionManager(String username, String password) {
        super(username, password);
    }

    public List<String> add(Group group, String ... email) throws IOException {
        return this.add(group.getId(), email);
    }

    public List<String> add(int groupId, String ... email) throws IOException {
        ArrayList<String> suppressions = new ArrayList<String>();
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("recipient_emails", email);
        String payload = this.jackson.writeValueAsString(map);
        Request post = Request.Post((String)(this.baseUrl + "/groups/" + groupId + "/suppressions")).addHeader("Accept", "application/json").addHeader("Authorization", this.authHeader);
        try {
            String json = post.bodyString(payload, ContentType.APPLICATION_JSON).execute().returnContent().asString();
            JsonNode array = this.jackson.readTree(json).path("recipient_emails");
            if (array.isArray()) {
                for (JsonNode entry : array) {
                    suppressions.add(entry.asText());
                }
            }
        }
        catch (HttpResponseException ex) {
            throw new IOException(ex);
        }
        return suppressions;
    }

    public void remove(Group group, String ... email) throws IOException {
        this.remove(group.getId(), email);
    }

    public void remove(int groupId, String ... email) throws IOException {
        for (String individual : email) {
            Request delete = Request.Delete((String)(this.baseUrl + "/groups/" + groupId + "/suppressions/" + individual)).addHeader("Accept", "application/json").addHeader("Authorization", this.authHeader);
            try {
                delete.execute();
            }
            catch (HttpResponseException ex) {
                throw new IOException(ex);
            }
        }
    }

    public List<String> retrieve(Group group) throws IOException {
        return this.retrieve(group.getId());
    }

    public List<String> retrieve(int groupId) throws IOException {
        ArrayList<String> suppressions = new ArrayList<String>();
        Request get = Request.Get((String)(this.baseUrl + "/groups/" + groupId + "/suppressions")).addHeader("Accept", "application/json").addHeader("Authorization", this.authHeader);
        try {
            String json = get.execute().returnContent().asString();
            JsonNode array = this.jackson.readTree(json);
            if (array.isArray()) {
                for (JsonNode entry : array) {
                    suppressions.add(entry.asText());
                }
            }
        }
        catch (HttpResponseException ex) {
            throw new IOException(ex);
        }
        return suppressions;
    }

    public List<Suppression> retrieve(String email) throws IOException {
        ArrayList<Suppression> suppressions = new ArrayList<Suppression>();
        Request get = Request.Get((String)(this.baseUrl + "/suppressions/" + email)).addHeader("Accept", "application/json").addHeader("Authorization", this.authHeader);
        try {
            String json = get.execute().returnContent().asString();
            TypeReference<Map<String, List<Suppression>>> typeRef = new TypeReference<Map<String, List<Suppression>>>(){};
            Map map = (Map)this.jackson.readValue(json, (TypeReference)typeRef);
            suppressions.addAll((Collection)map.get("suppressions"));
        }
        catch (HttpResponseException ex) {
            throw new IOException(ex);
        }
        return suppressions;
    }

    public void save(String email, List<Suppression> suppressions) throws IOException {
        HashSet<Integer> previouslySuppressed = new HashSet<Integer>();
        for (Suppression s : this.retrieve(email)) {
            if (!s.isSuppressed()) continue;
            previouslySuppressed.add(s.getId());
        }
        for (Suppression s : suppressions) {
            if (s.isSuppressed() && !previouslySuppressed.contains(s.getId())) {
                this.add(s.getId(), email);
                continue;
            }
            if (s.isSuppressed() || !previouslySuppressed.contains(s.getId())) continue;
            this.remove(s.getId(), email);
        }
    }
}

