/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.concurrent;

public final class ReentrantLock {
    private Thread _owner = null;
    private int _counter = 0;
    private final Object _sync = new Object();

    public void lock() {
        boolean interrupted = this.doAcquire(1);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockInterruptibly() throws InterruptedException {
        Object object = this._sync;
        synchronized (object) {
            while (this._owner != null && this._owner != Thread.currentThread()) {
                this._sync.wait();
            }
            this._owner = Thread.currentThread();
            ++this._counter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock() {
        Object object = this._sync;
        synchronized (object) {
            if (this._owner == null || this._owner == Thread.currentThread()) {
                this._owner = Thread.currentThread();
                ++this._counter;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() throws IllegalMonitorStateException {
        Object object = this._sync;
        synchronized (object) {
            if (this._owner != Thread.currentThread()) {
                throw new IllegalMonitorStateException("the caller thread is not the owner of this lock");
            }
            --this._counter;
            if (this._counter == 0) {
                this._owner = null;
                this._sync.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOwner() {
        Object object = this._sync;
        synchronized (object) {
            return this._owner == Thread.currentThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        Object object = this._sync;
        synchronized (object) {
            return this._counter;
        }
    }

    public Condition newCondition() {
        return new Condition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doReleaseFully() {
        Object object = this._sync;
        synchronized (object) {
            if (this._owner != Thread.currentThread()) {
                throw new IllegalMonitorStateException("the caller thread is not the owner of this lock");
            }
            int c = this._counter;
            this._counter = 0;
            this._sync.notify();
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doAcquire(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count");
        }
        Object object = this._sync;
        synchronized (object) {
            boolean interrupted = false;
            while (this._owner != null && this._owner != Thread.currentThread()) {
                try {
                    this._sync.wait();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
            this._owner = Thread.currentThread();
            this._counter += count;
            return interrupted;
        }
    }

    public final class Condition {
        private final Object _conditionSync = new Object();

        protected Condition() {
        }

        public void await() throws InterruptedException {
            this.await(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await(long millis) throws InterruptedException {
            int oldCount = 0;
            try {
                Object object = this._conditionSync;
                synchronized (object) {
                    oldCount = ReentrantLock.this.doReleaseFully();
                    this._conditionSync.wait(millis);
                }
            }
            finally {
                ReentrantLock.this.doAcquire(oldCount);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void awaitUninterruptibly() {
            int oldCount;
            boolean interrupted = false;
            Object object = this._conditionSync;
            synchronized (object) {
                oldCount = ReentrantLock.this.doReleaseFully();
                while (true) {
                    try {
                        this._conditionSync.wait();
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
            }
            if (ReentrantLock.this.doAcquire(oldCount)) {
                interrupted = true;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void signal() {
            if (!ReentrantLock.this.isOwner()) {
                throw new IllegalMonitorStateException();
            }
            Object object = this._conditionSync;
            synchronized (object) {
                this._conditionSync.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void signalAll() {
            if (!ReentrantLock.this.isOwner()) {
                throw new IllegalMonitorStateException();
            }
            Object object = this._conditionSync;
            synchronized (object) {
                this._conditionSync.notifyAll();
            }
        }
    }
}

