/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.concurrent;

import com.github.libxjava.concurrent.AtomicNumber;
import com.github.libxjava.concurrent.IThreadFactory;
import com.github.libxjava.concurrent.TaskFuture;

public class ScheduledTaskExecutor {
    final AtomicNumber totalThreads;
    private final IThreadFactory _threadFactory;
    private final TaskQueue _taskQueue;
    private final int _maxPoolSize;
    private final long _keepAliveTimeInMillis;

    public ScheduledTaskExecutor(int initialPoolSize, int maxPoolSize, long keepAliveTimeInMillis, IThreadFactory threadFactory) {
        if (initialPoolSize < 0 || maxPoolSize < 0 || initialPoolSize > maxPoolSize) {
            throw new IllegalArgumentException("pool sizes");
        }
        this._maxPoolSize = maxPoolSize;
        this._threadFactory = threadFactory;
        this._taskQueue = new TaskQueue();
        this._keepAliveTimeInMillis = keepAliveTimeInMillis;
        this.totalThreads = new AtomicNumber(initialPoolSize);
        for (int i = 0; i < initialPoolSize; ++i) {
            this.createAndStartThread();
        }
    }

    public TaskFuture submit(Runnable target) {
        return this.scheduleAtFixedRate(target, 0L, 0L);
    }

    public TaskFuture schedule(Runnable target, long delayInMillis) {
        return this.scheduleAtFixedRate(target, delayInMillis, 0L);
    }

    public TaskFuture scheduleAtFixedRate(Runnable target, long delayInMillis, long periodInMillis) {
        if (delayInMillis < 0L || periodInMillis < 0L) {
            throw new IllegalArgumentException("delay or period");
        }
        TaskFuture task = this.createAndInitialiseTaskFuture(target, delayInMillis, periodInMillis);
        this.addTaskForExecution(task);
        return task;
    }

    protected void beforeExecute(Thread workThread, TaskFuture task) {
    }

    protected void afterExecute(TaskFuture task, Throwable t) {
    }

    protected TaskFuture createTaskFuture(Object target) {
        return new TaskFuture();
    }

    TaskFuture getTask() {
        long deadline = this._keepAliveTimeInMillis + System.currentTimeMillis();
        while (true) {
            try {
                TaskFuture taskFuture = this._taskQueue.waitForTask(deadline);
                return taskFuture;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        finally {
            this.ensureEnoughThreadsStarted();
        }
    }

    void addTask(TaskFuture task) {
        this._taskQueue.addTask(task);
    }

    void removeTask(TaskFuture task) {
        this._taskQueue.removeTask(task);
    }

    private TaskFuture createAndInitialiseTaskFuture(Runnable target, long delay, long period) {
        TaskFuture task = this.createTaskFuture(target);
        task.executor = this;
        task.target = target;
        task.start = System.currentTimeMillis() + delay;
        task.period = period;
        return task;
    }

    private void createAndStartThread() {
        Thread thr;
        Worker worker = new Worker();
        worker.thread = thr = this._threadFactory.newThread(worker);
        thr.start();
    }

    private void addTaskForExecution(TaskFuture task) {
        this._taskQueue.addTask(task);
        this.ensureEnoughThreadsStarted();
    }

    private void ensureEnoughThreadsStarted() {
        while (this._taskQueue.hasUnassignedTasks()) {
            int threadCount = this.totalThreads.get();
            if (threadCount < this._maxPoolSize) {
                if (!this.totalThreads.compareAndSet(threadCount, threadCount + 1)) continue;
                this.createAndStartThread();
                break;
            }
            System.err.println("WARNING: not enough worker threads");
        }
    }

    private final class Worker
    implements Runnable {
        protected Thread thread;

        protected Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                TaskFuture task = null;
                while ((task = ScheduledTaskExecutor.this.getTask()) != null) {
                    this.executeTask(task);
                    task = null;
                }
            }
            finally {
                ScheduledTaskExecutor.this.totalThreads.updateAndGet(-1);
            }
        }

        private void executeTask(TaskFuture task) {
            ScheduledTaskExecutor.this.beforeExecute(this.thread, task);
            RuntimeException t = null;
            try {
                task.doRun();
            }
            catch (RuntimeException re) {
                t = re;
            }
            ScheduledTaskExecutor.this.afterExecute(task, t);
        }
    }

    private static final class TaskQueue {
        private TaskFuture _head = null;
        private int _count = 0;
        private int _waitingThreads = 0;

        TaskQueue() {
        }

        synchronized void addTask(TaskFuture task) {
            if (task.next != null) {
                throw new IllegalArgumentException("task already in queue");
            }
            if (this._head == null) {
                this._head = task;
                this.notify();
            } else if (this._head.start > task.start) {
                task.next = this._head;
                this._head = task;
                this.notify();
            } else {
                TaskFuture previous = this._head;
                TaskFuture comp = previous.next;
                while (comp != null && comp.start <= task.start) {
                    previous = comp;
                    comp = comp.next;
                }
                task.next = previous.next;
                previous.next = task;
            }
            ++this._count;
        }

        synchronized void removeTask(TaskFuture task) {
            if (this._head == task) {
                this._head = task.next;
                task.next = null;
                --this._count;
                return;
            }
            TaskFuture previous = this._head;
            while (previous != null && previous.next != task) {
                previous = previous.next;
            }
            if (previous != null) {
                previous.next = task.next;
                task.next = null;
                --this._count;
            }
        }

        synchronized TaskFuture waitForTask(long deadline) throws InterruptedException {
            ++this._waitingThreads;
            try {
                while (true) {
                    long currentTime = System.currentTimeMillis();
                    long waitUntil = deadline;
                    if (this._head != null) {
                        if (currentTime >= this._head.start) {
                            TaskFuture task = this._head;
                            this._head = this._head.next;
                            task.next = null;
                            --this._count;
                            TaskFuture taskFuture = task;
                            return taskFuture;
                        }
                        waitUntil = this._head.start;
                    }
                    if (currentTime >= deadline) {
                        TaskFuture task = null;
                        return task;
                    }
                    long toWait = waitUntil - currentTime;
                    if (toWait <= 0L) continue;
                    this.wait(toWait);
                }
            }
            finally {
                --this._waitingThreads;
            }
        }

        synchronized boolean hasUnassignedTasks() {
            return this._waitingThreads <= 0 && this._count > 0;
        }
    }
}

