/*
 * Decompiled with CFR 0.152.
 */
package com.github.memorylorry.converter.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.memorylorry.converter.JSON2Slice;
import com.github.memorylorry.type.Slice;
import com.github.memorylorry.type.common.Column;
import com.github.memorylorry.type.common.CommonList;
import com.github.memorylorry.type.common.Filter;
import com.github.memorylorry.type.common.Order;
import com.github.memorylorry.type.common.Table;
import com.github.memorylorry.type.exception.SliceFormatNotSupportedException;
import com.github.memorylorry.util.TestErrorUtil;
import java.util.ArrayList;

public class SimpleJSON2Slice
implements JSON2Slice {
    @Override
    public Slice format(String json) throws SliceFormatNotSupportedException {
        JSONObject obj = (JSONObject)JSONObject.parse((String)json);
        return this.format(obj);
    }

    @Override
    public Slice format(JSONObject root) throws SliceFormatNotSupportedException {
        Slice slice = new Slice();
        String title = root.getString("title");
        TestErrorUtil.testNotNull(title);
        slice.setTitle(title);
        String database = root.getString("database");
        TestErrorUtil.testNotNull(database);
        slice.setDatabase(database);
        String table = root.getString("table");
        TestErrorUtil.testNotNull(table);
        TestErrorUtil.testNotInt(table);
        TestErrorUtil.testNot0Len(table);
        slice.setTable(new Table(table));
        String type = root.getString("type");
        TestErrorUtil.testNotNull(type);
        TestErrorUtil.testNotInt(type);
        TestErrorUtil.testNot0Len(type);
        slice.setType(type);
        JSONArray dimensionJSON = root.getJSONArray("dimension");
        TestErrorUtil.testNotNull(dimensionJSON);
        CommonList<Column> dimension = this.parse2ColumnList(dimensionJSON);
        slice.setDimensions(dimension);
        JSONArray metricJSON = root.getJSONArray("metric");
        TestErrorUtil.testNotNull(metricJSON);
        CommonList<Column> metric = this.parse2ColumnList(metricJSON);
        slice.setMetrics(metric);
        JSONArray filterJSON = root.getJSONArray("filter");
        TestErrorUtil.testNotNull(filterJSON);
        CommonList<Filter> filterList = this.parse2FilterList(filterJSON);
        slice.setFilters(filterList);
        JSONArray orderJSON = root.getJSONArray("order");
        TestErrorUtil.testNotNull(orderJSON);
        CommonList<Order> orderList = this.parse2OrderList(orderJSON);
        slice.setOrders(orderList);
        String limit = root.getString("limit");
        TestErrorUtil.testNotNull(limit);
        slice.setLimit(limit);
        return slice;
    }

    private CommonList<Column> parse2ColumnList(JSONArray array) {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject obj = (JSONObject)array.get(i);
            String name = obj.getString("name");
            String verbose = obj.getString("verbose");
            String expression = obj.getString("expression");
            columns.add(new Column(name, verbose, expression));
        }
        CommonList<Column> columnList = new CommonList<Column>();
        columnList.setColumns(columns);
        return columnList;
    }

    private CommonList<Filter> parse2FilterList(JSONArray array) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject obj = (JSONObject)array.get(i);
            String name = obj.getString("name");
            String verbose = obj.getString("verbose");
            String expression = obj.getString("expression");
            int type = obj.getInteger("type");
            String sql = obj.getString("sql");
            filters.add(new Filter(name, verbose, expression, sql, type));
        }
        CommonList<Filter> columnList = new CommonList<Filter>();
        columnList.setColumns(filters);
        return columnList;
    }

    private CommonList<Order> parse2OrderList(JSONArray array) {
        ArrayList<Order> orders = new ArrayList<Order>();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject obj = (JSONObject)array.get(i);
            String name = obj.getString("name");
            String verbose = obj.getString("verbose");
            String expression = obj.getString("expression");
            int type = obj.getInteger("type");
            String sql = obj.getString("sql");
            orders.add(new Order(name, verbose, expression, sql, type));
        }
        CommonList<Order> columnList = new CommonList<Order>();
        columnList.setColumns(orders);
        return columnList;
    }
}

