/*
 * Decompiled with CFR 0.152.
 */
package com.github.myibu.algorithm.validate;

public class IDCardChecker {
    private static int pow(int m, int n) {
        int res = 1;
        for (int i = 0; i < n; ++i) {
            res *= m;
        }
        return res;
    }

    public static boolean check(String id) {
        int i;
        if (id == null || !id.matches("[\\d]{17}[xX0-9]")) {
            return false;
        }
        char[] chars = new StringBuffer(id).reverse().toString().toCharArray();
        int[] W = new int[chars.length + 1];
        int[] A = new int[chars.length + 1];
        W[0] = Integer.MAX_VALUE;
        A[0] = Integer.MAX_VALUE;
        for (i = 1; i < 19; ++i) {
            W[i] = IDCardChecker.pow(2, i - 1) % 11;
        }
        for (i = 1; i < 19; ++i) {
            A[i] = i == 1 && (chars[1] == 'X' || chars[1] == 'x') ? 10 : Integer.parseInt("" + chars[i - 1]);
        }
        int res1 = 0;
        for (int i2 = 2; i2 < 19; ++i2) {
            res1 += A[i2] * W[i2];
        }
        int res2 = res1 + A[1] * W[1];
        int a1 = (12 - res1 % 11) % 11;
        return A[1] == a1 && res2 % 11 == 1;
    }
}

