/*
 * Decompiled with CFR 0.152.
 */
package com.github.myibu.algorithm.compress;

import com.github.myibu.algorithm.compress.Compressor;
import com.github.myibu.algorithm.data.Bits;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;

public class LZWCompressor
implements Compressor {
    private static final int BITS = 12;
    private static final int MAX_CODE = 4095;
    private static final Map<String, Integer> STANDARD_STR_TO_CODE_DICT = new HashMap<String, Integer>();
    private static final Map<Integer, String> STANDARD_CODE_TO_STR_DICT = new HashMap<Integer, String>();
    private boolean isDebug = false;

    @Override
    public int compress(byte[] in_data, int in_len, byte[] out_data) {
        HashMap<String, Integer> str2CodeDict = new HashMap<String, Integer>(STANDARD_STR_TO_CODE_DICT);
        Object s = "";
        int ip = 0;
        Bits seq = new Bits();
        while (ip < in_len) {
            byte ch;
            if (str2CodeDict.containsKey((String)s + (char)(ch = in_data[ip++]))) {
                s = (String)s + (char)ch;
                continue;
            }
            if (this.isDebug) {
                System.out.println("entry=" + (String)s + ", code=" + str2CodeDict.get(s));
                if (((String)s).equals("t")) {
                    System.out.println();
                }
            }
            seq.append(Bits.ofBits((Integer)str2CodeDict.get(s), 12));
            str2CodeDict.put((String)s + (char)ch, str2CodeDict.size());
            s = "" + (char)ch;
        }
        seq.append(Bits.ofBits((Integer)str2CodeDict.get(s), 12));
        if (this.isDebug) {
            System.out.println("entry=" + (String)s + ", code=" + str2CodeDict.get(s));
        }
        byte[] fr = seq.toByteArray();
        System.arraycopy(fr, 0, out_data, 0, fr.length);
        if (this.isDebug) {
            System.out.println("after encode: bits=" + seq);
            System.out.println("after encode: compressed rate=" + new BigDecimal((double)fr.length * 100.0 / (double)in_len).setScale(2, RoundingMode.HALF_UP) + "%");
        }
        return fr.length;
    }

    @Override
    public int decompress(byte[] in_data, int in_len, byte[] out_data) {
        HashMap<Integer, String> code2StrDict = new HashMap<Integer, String>(STANDARD_CODE_TO_STR_DICT);
        Bits bits = Bits.ofByte(in_data);
        if (this.isDebug) {
            System.out.println("before decode: bits=" + bits);
        }
        Bits seq = new Bits();
        int ip = 0;
        Bits b1 = bits.subBits(ip, ip + 12);
        int preCode = b1.toInt();
        Object entry = (String)code2StrDict.get(preCode);
        if (this.isDebug) {
            System.out.println("code=" + preCode + ", entry=" + (String)entry);
        }
        seq.append(Bits.ofRawString((String)entry));
        ip += 12;
        while (ip < bits.length() && ip + 12 <= bits.length()) {
            b1 = bits.subBits(ip, ip + 12);
            int curCode = b1.toInt();
            if (code2StrDict.containsKey(curCode)) {
                entry = (String)code2StrDict.get(curCode);
            } else {
                entry = (String)code2StrDict.get(preCode);
                entry = (String)entry + ((String)entry).charAt(0);
            }
            if (this.isDebug) {
                System.out.println("code=" + curCode + ", entry=" + (String)entry);
            }
            seq.append(Bits.ofRawString((String)entry));
            char ch = ((String)entry).charAt(0);
            code2StrDict.put(code2StrDict.size(), (String)code2StrDict.get(preCode) + ch);
            preCode = curCode;
            ip += 12;
        }
        int len = seq.byteLength();
        for (int i = 0; i < len; ++i) {
            out_data[i] = seq.getByte(i).toByte();
        }
        return len;
    }

    @Override
    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    static {
        int b = -128;
        int i = 0;
        while (b < 127) {
            STANDARD_STR_TO_CODE_DICT.put("" + (char)b, i);
            STANDARD_CODE_TO_STR_DICT.put(i, "" + (char)b);
            b = (byte)(b + 1);
            ++i;
        }
    }
}

