/*
 * Decompiled with CFR 0.152.
 */
package com.github.myibu.algorithm.endode;

import com.github.myibu.algorithm.data.Bit;
import com.github.myibu.algorithm.data.Bits;
import com.github.myibu.algorithm.endode.Encoder;

public class GolombEncoder
implements Encoder {
    public Bits encode(int n, int m) {
        Bits bits = new Bits();
        int q = (int)Math.floor((double)n * 1.0 / (double)m);
        bits.append(Bits.ofOne(Math.max(0, q))).append(Bits.ofZero(1));
        int r = n % m;
        int k = (int)Math.ceil(Math.log(m) / Math.log(2.0));
        if ((m & 1) == 0) {
            return bits.append(GolombEncoder.encodeToBinary(r, k));
        }
        if ((double)r < Math.pow(2.0, k) - (double)m) {
            return bits.append(GolombEncoder.encodeToTruncatedBinary(r, m));
        }
        return bits.append(GolombEncoder.encodeToTruncatedBinary(r, m));
    }

    public static Bits encodeToTruncatedBinary(int x, int n) {
        int k = 0;
        for (int t = n; t > 1; t >>= 1) {
            ++k;
        }
        int u = (1 << k + 1) - n;
        if (x < u) {
            return GolombEncoder.encodeToBinary(x, k);
        }
        return GolombEncoder.encodeToBinary(x + u, k + 1);
    }

    public static Bits encodeToBinary(int x, int len) {
        Bits s = new Bits();
        while (x != 0) {
            s = (x & 1) == 0 ? Bits.ofZero().append(s) : Bits.ofOne().append(s);
            x >>= 1;
        }
        while (s.length() < len) {
            s = Bits.ofZero().append(s);
        }
        return s;
    }

    public int decode(Bits bits, int m) {
        boolean isRStart = false;
        Bits qb = new Bits();
        Bits rb = new Bits();
        for (Bit bit : bits) {
            if (!isRStart && bit == Bit.ZERO) {
                isRStart = true;
                continue;
            }
            if (!isRStart) {
                qb.append(bit);
                continue;
            }
            rb.append(bit);
        }
        int q = qb.length();
        int r = 0;
        r = (m & 1) == 0 ? GolombEncoder.encodeToBinary(rb) : GolombEncoder.decodeTruncatedBinary(rb, m);
        return q * m + r;
    }

    public static int decodeTruncatedBinary(Bits bits, int m) {
        int k = 0;
        for (int t = m; t > 1; t >>= 1) {
            ++k;
        }
        int u = (1 << k + 1) - m;
        int x = GolombEncoder.encodeToBinary(bits);
        return x < u ? x : x - u;
    }

    public static int encodeToBinary(Bits bits) {
        int x = 0;
        for (int i = 0; i < bits.length(); ++i) {
            x += bits.get(i).value() << bits.length() - i - 1;
        }
        return x;
    }
}

