/*
 * Decompiled with CFR 0.152.
 */
package com.github.myibu.algorithm.compress;

import com.github.myibu.algorithm.compress.Compressor;
import com.github.myibu.algorithm.data.Bits;
import com.github.myibu.algorithm.endode.GolombEncoder;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class LZ77Compressor
implements Compressor {
    private static int DEFAULT_SEARCH_BUFFER_LENGTH = 7;
    private static int DEFAULT_LOOK_AHEAD_WINDOW_LENGTH = 5;
    private int s = DEFAULT_SEARCH_BUFFER_LENGTH;
    private int l = DEFAULT_LOOK_AHEAD_WINDOW_LENGTH;
    private boolean isDebug = false;

    @Override
    public int compress(byte[] in_data, int in_len, byte[] out_data) {
        if (this.l > in_len) {
            System.arraycopy(in_data, 0, out_data, 0, in_len);
            return in_len;
        }
        ArrayList<List<Integer>> tuples = new ArrayList<List<Integer>>();
        byte[] sBuf = new byte[this.s];
        byte[] lWindow = new byte[this.l];
        int sp = 0;
        int lp = this.l;
        int ip = 0;
        boolean op = false;
        while (lWindow.length > 0 && ip < in_len) {
            int lEnd;
            int sStart = 0;
            int sEnd = sp < this.s ? sp : this.s;
            for (int i = sStart; i < sEnd; ++i) {
                sBuf[i] = in_data[ip - i - 1];
            }
            int lStart = 0;
            int n = lEnd = ip + this.l < in_len ? this.l : in_len - ip;
            if (lEnd < this.l) {
                lWindow = new byte[lEnd];
            }
            for (int i = lStart; i < lEnd; ++i) {
                lWindow[i] = in_data[ip + i];
            }
            int llStart = sEnd - 1;
            int rrStart = 0;
            int llEnd = 0;
            int rrEnd = lp = lEnd;
            int minMatched = 1;
            int minIndex = 0;
            for (int i = llStart; i >= 0; --i) {
                int matched = 0;
                int left = i;
                int right = rrStart;
                while (left >= llEnd && right < rrEnd && sBuf[left--] == lWindow[right++]) {
                    ++matched;
                }
                if (matched < minMatched) continue;
                minIndex = i;
                minMatched = matched;
            }
            int lWindowLen = lWindow.length;
            if (lWindowLen == 1) {
                minIndex = 0;
            }
            if (minIndex > 0) {
                tuples.add(Arrays.asList(minIndex + 1, minMatched, minMatched == lWindowLen ? null : Integer.valueOf(lWindow[minMatched])));
                sp += minMatched == lWindowLen ? minMatched : minMatched + 1;
                ip += minMatched == lWindowLen ? minMatched : minMatched + 1;
            } else {
                ++sp;
                ++ip;
                tuples.add(Arrays.asList(0, 0, lWindow[0]));
            }
            if (!this.isDebug) continue;
            System.out.println(", SearchBuffer=" + new StringBuilder(new String(sBuf)).reverse().toString() + ", LookaheadWindow=" + new String(lWindow) + " | " + tuples.get(tuples.size() - 1));
        }
        int compressedLen = this.doEncode(tuples, out_data);
        if (this.isDebug) {
            System.out.println("after encode: compressed rate=" + new BigDecimal((double)compressedLen * 100.0 / (double)in_len).setScale(2, RoundingMode.HALF_UP) + "%");
        }
        return compressedLen;
    }

    private int doEncode(List<List<Integer>> tuples, byte[] out_data) {
        Bits finalRes = new Bits();
        GolombEncoder encoder = new GolombEncoder();
        for (List<Integer> tuple : tuples) {
            Bits bits = new Bits();
            Bits bits1 = GolombEncoder.encodeToBinary(tuple.get(0), (int)Math.ceil(Math.log(this.s) / Math.log(2.0)));
            bits.append(bits1);
            Bits bits2 = encoder.encode(tuple.get(1), this.l);
            bits.append(bits2);
            Bits bits3 = new Bits();
            if (tuple.get(2) != null) {
                bits3 = Bits.ofByte((byte)tuple.get(2).intValue());
                bits.append(bits3);
            }
            if (this.isDebug) {
                System.out.println(tuple + " encoded result: (" + bits1 + ", " + bits2 + ", " + bits3 + ")");
            }
            finalRes.append(bits);
        }
        byte[] fr = finalRes.toByteArray();
        System.arraycopy(fr, 0, out_data, 0, fr.length);
        if (this.isDebug) {
            System.out.println("after encode: bits=" + finalRes);
        }
        return fr.length;
    }

    @Override
    public int decompress(byte[] in_data, int in_len, byte[] out_data) {
        int e1 = (int)Math.ceil(Math.log(this.s) / Math.log(2.0));
        GolombEncoder encoder = new GolombEncoder();
        HashSet<Bits> allEncodeSeq = new HashSet<Bits>();
        for (int i = 0; i <= this.l; ++i) {
            allEncodeSeq.add(encoder.encode(i, this.l));
        }
        List sortedEncodeSeq = allEncodeSeq.stream().sorted(Comparator.comparingInt(Bits::length)).collect(Collectors.toList());
        Bits bits = Bits.ofByte(in_data);
        if (this.isDebug) {
            System.out.println("before decode: bits=" + bits);
        }
        int ip = 0;
        ArrayList<List<Integer>> tuples = new ArrayList<List<Integer>>();
        while (ip < bits.length() && ip + e1 <= bits.length()) {
            Bits b1 = bits.subBits(ip, ip + e1);
            ip += e1;
            int offset = GolombEncoder.encodeToBinary(b1);
            int length = -1;
            for (Bits sortedEncode : sortedEncodeSeq) {
                if (ip + sortedEncode.length() >= bits.length() || !sortedEncode.equals(bits.subBits(ip, ip + sortedEncode.length()))) continue;
                length = encoder.decode(sortedEncode, this.l);
                ip += sortedEncode.length();
                break;
            }
            if (length == -1) break;
            if (length != this.l && ip + 8 <= bits.length()) {
                byte symbol = bits.subBits(ip, ip + 8).toByte();
                tuples.add(Arrays.asList(offset, length, symbol));
                ip += 8;
                continue;
            }
            tuples.add(Arrays.asList(offset, length, null));
        }
        if (this.isDebug) {
            System.out.println("decode tuples=" + tuples);
        }
        return this.doDecode(tuples, out_data);
    }

    private int doDecode(List<List<Integer>> tuples, byte[] out_data) {
        Bits seq = new Bits();
        for (List<Integer> tuple : tuples) {
            int offset = tuple.get(0);
            int length = tuple.get(1);
            if (tuple.get(2) != null) {
                int symbol = tuple.get(2);
                Bits sb = Bits.ofByte((byte)symbol);
                if (offset == 0) {
                    seq.append(sb);
                    if (!this.isDebug) continue;
                    System.out.println(tuple + ", seq=" + new String(seq.toByteArray()));
                    continue;
                }
                int start = seq.byteLength() < this.s ? seq.byteLength() - offset : this.s - offset;
                int used = seq.byteLength() < this.s ? 0 : seq.byteLength() - this.s;
                seq.append(seq.subBits((used + start) * 8, (used + start + length) * 8)).append(sb);
                if (!this.isDebug) continue;
                System.out.println(tuple + ", seq=" + new String(seq.toByteArray()));
                continue;
            }
            int start = seq.byteLength() < this.s ? seq.byteLength() - offset : this.s - offset;
            int used = seq.byteLength() < this.s ? 0 : seq.byteLength() - this.s;
            seq.append(seq.subBits((used + start) * 8, (used + start + length) * 8));
            if (!this.isDebug) continue;
            System.out.println(tuple + ", seq=" + new String(seq.toByteArray()));
        }
        if (this.isDebug) {
            System.out.println("after decode, bits=" + seq);
        }
        int len = seq.byteLength();
        for (int i = 0; i < len; ++i) {
            out_data[i] = seq.getByte(i).toByte();
        }
        return len;
    }

    @Override
    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public void setSL(int s, int l) {
        this.s = s;
        this.l = l;
    }
}

