/*
 * Decompiled with CFR 0.152.
 */
package com.github.myibu.algorithm.sort;

import com.github.myibu.algorithm.sort.AbstractSorts;
import java.util.Comparator;

public class InsertionSorts
extends AbstractSorts {
    public static void insertSort(byte[] a, int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            byte key = a[i];
            for (int j = i - 1; j >= fromIndex && a[j] > key; --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = key;
        }
    }

    public static void insertSort(short[] a, int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            short key = a[i];
            for (int j = i - 1; j >= fromIndex && a[j] > key; --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = key;
        }
    }

    public static void insertSort(int[] a, int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            int key = a[i];
            for (int j = i - 1; j >= fromIndex && a[j] > key; --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = key;
        }
    }

    public static void insertSort(long[] a, int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            long key = a[i];
            for (int j = i - 1; j >= fromIndex && a[j] > key; --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = key;
        }
    }

    public static void insertSort(float[] a, int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            float key = a[i];
            for (int j = i - 1; j >= fromIndex && a[j] > key; --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = key;
        }
    }

    public static void insertSort(double[] a, int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            double key = a[i];
            for (int j = i - 1; j >= fromIndex && a[j] > key; --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = key;
        }
    }

    public static void insertSort(char[] a, int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            char key = a[i];
            for (int j = i - 1; j >= fromIndex && a[j] > key; --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = key;
        }
    }

    public static void insertSort(Object[] a, int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            Object key = a[i];
            for (int j = i - 1; j >= fromIndex && ((Comparable)a[j]).compareTo(key) > 0; --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = key;
        }
    }

    public static <T> void insertSort(T[] a, int fromIndex, int toIndex, Comparator<? super T> c) {
        for (int i = fromIndex; i < toIndex; ++i) {
            T key = a[i];
            for (int j = i - 1; j >= fromIndex && c.compare(a[j], key) > 0; --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = key;
        }
    }

    @Override
    public void sort(byte[] a, int fromIndex, int toIndex) {
        InsertionSorts.insertSort(a, fromIndex, toIndex);
    }

    @Override
    public void sort(short[] a, int fromIndex, int toIndex) {
        InsertionSorts.insertSort(a, fromIndex, toIndex);
    }

    @Override
    public void sort(int[] a, int fromIndex, int toIndex) {
        InsertionSorts.insertSort(a, fromIndex, toIndex);
    }

    @Override
    public void sort(long[] a, int fromIndex, int toIndex) {
        InsertionSorts.insertSort(a, fromIndex, toIndex);
    }

    @Override
    public void sort(float[] a, int fromIndex, int toIndex) {
        InsertionSorts.insertSort(a, fromIndex, toIndex);
    }

    @Override
    public void sort(double[] a, int fromIndex, int toIndex) {
        InsertionSorts.insertSort(a, fromIndex, toIndex);
    }

    @Override
    public void sort(char[] a, int fromIndex, int toIndex) {
        InsertionSorts.insertSort(a, fromIndex, toIndex);
    }

    @Override
    public void sort(Object[] a, int fromIndex, int toIndex) {
        InsertionSorts.insertSort(a, fromIndex, toIndex);
    }

    @Override
    public <T> void sort(T[] a, int fromIndex, int toIndex, Comparator<? super T> c) {
        InsertionSorts.insertSort(a, fromIndex, toIndex, c);
    }
}

