/*
 * Decompiled with CFR 0.152.
 */
package com.github.myibu.algorithm.sort;

import com.github.myibu.algorithm.sort.AbstractSorts;
import com.github.myibu.algorithm.sort.InsertionSorts;
import com.github.myibu.algorithm.sort.MergeSorts;
import java.util.Comparator;

public class TimSorts
extends AbstractSorts {
    private static final int MIN_MERGE = 32;

    public static void timSort(int[] arr, int n) {
        int minRun = TimSorts.minRunLength(n);
        for (int i = 0; i < n; i += minRun) {
            InsertionSorts.insertSort(arr, i, Math.min(i + 32 - 1, n - 1) + 1);
        }
        for (int size = minRun; size < n; size = 2 * size) {
            for (int left = 0; left < n; left += 2 * size) {
                int mid = left + size - 1;
                int right = Math.min(left + 2 * size - 1, n - 1);
                if (mid >= right) continue;
                MergeSorts.merge(arr, left, mid, right);
            }
        }
    }

    private static int minRunLength(int n) {
        assert (n >= 0);
        int r = 0;
        while (n >= 32) {
            r |= n & 1;
            n >>= 1;
        }
        return n + r;
    }

    public static void timSort(byte[] arr, int leftIndex, int rightIndex) {
        int minRun = TimSorts.minRunLength(rightIndex - leftIndex);
        for (int i = leftIndex; i < rightIndex; i += minRun) {
            InsertionSorts.insertSort(arr, i, Math.min(i + 32 - 1, rightIndex - 1) + 1);
        }
        for (int size = minRun; size < rightIndex; size = 2 * size) {
            for (int left = leftIndex; left < rightIndex; left += 2 * size) {
                int mid = left + size - 1;
                int right = Math.min(left + 2 * size - 1, rightIndex - 1);
                if (mid >= right) continue;
                MergeSorts.merge(arr, left, mid, right);
            }
        }
    }

    public static void timSort(short[] arr, int leftIndex, int rightIndex) {
        int minRun = TimSorts.minRunLength(rightIndex - leftIndex);
        for (int i = leftIndex; i < rightIndex; i += minRun) {
            InsertionSorts.insertSort(arr, i, Math.min(i + 32 - 1, rightIndex - 1) + 1);
        }
        for (int size = minRun; size < rightIndex; size = 2 * size) {
            for (int left = leftIndex; left < rightIndex; left += 2 * size) {
                int mid = left + size - 1;
                int right = Math.min(left + 2 * size - 1, rightIndex - 1);
                if (mid >= right) continue;
                MergeSorts.merge(arr, left, mid, right);
            }
        }
    }

    public static void timSort(int[] arr, int leftIndex, int rightIndex) {
        int minRun = TimSorts.minRunLength(rightIndex - leftIndex);
        for (int i = leftIndex; i < rightIndex; i += minRun) {
            InsertionSorts.insertSort(arr, i, Math.min(i + 32 - 1, rightIndex - 1) + 1);
        }
        for (int size = minRun; size < rightIndex; size = 2 * size) {
            for (int left = leftIndex; left < rightIndex; left += 2 * size) {
                int mid = left + size - 1;
                int right = Math.min(left + 2 * size - 1, rightIndex - 1);
                if (mid >= right) continue;
                MergeSorts.merge(arr, left, mid, right);
            }
        }
    }

    public static void timSort(long[] arr, int leftIndex, int rightIndex) {
        int minRun = TimSorts.minRunLength(rightIndex - leftIndex);
        for (int i = leftIndex; i < rightIndex; i += minRun) {
            InsertionSorts.insertSort(arr, i, Math.min(i + 32 - 1, rightIndex - 1) + 1);
        }
        for (int size = minRun; size < rightIndex; size = 2 * size) {
            for (int left = leftIndex; left < rightIndex; left += 2 * size) {
                int mid = left + size - 1;
                int right = Math.min(left + 2 * size - 1, rightIndex - 1);
                if (mid >= right) continue;
                MergeSorts.merge(arr, left, mid, right);
            }
        }
    }

    public static void timSort(float[] arr, int leftIndex, int rightIndex) {
        int minRun = TimSorts.minRunLength(rightIndex - leftIndex);
        for (int i = leftIndex; i < rightIndex; i += minRun) {
            InsertionSorts.insertSort(arr, i, Math.min(i + 32 - 1, rightIndex - 1) + 1);
        }
        for (int size = minRun; size < rightIndex; size = 2 * size) {
            for (int left = leftIndex; left < rightIndex; left += 2 * size) {
                int mid = left + size - 1;
                int right = Math.min(left + 2 * size - 1, rightIndex - 1);
                if (mid >= right) continue;
                MergeSorts.merge(arr, left, mid, right);
            }
        }
    }

    public static void timSort(double[] arr, int leftIndex, int rightIndex) {
        int minRun = TimSorts.minRunLength(rightIndex - leftIndex);
        for (int i = leftIndex; i < rightIndex; i += minRun) {
            InsertionSorts.insertSort(arr, i, Math.min(i + 32 - 1, rightIndex - 1) + 1);
        }
        for (int size = minRun; size < rightIndex; size = 2 * size) {
            for (int left = leftIndex; left < rightIndex; left += 2 * size) {
                int mid = left + size - 1;
                int right = Math.min(left + 2 * size - 1, rightIndex - 1);
                if (mid >= right) continue;
                MergeSorts.merge(arr, left, mid, right);
            }
        }
    }

    public static void timSort(char[] arr, int leftIndex, int rightIndex) {
        int minRun = TimSorts.minRunLength(rightIndex - leftIndex);
        for (int i = leftIndex; i < rightIndex; i += minRun) {
            InsertionSorts.insertSort(arr, i, Math.min(i + 32 - 1, rightIndex - 1) + 1);
        }
        for (int size = minRun; size < rightIndex; size = 2 * size) {
            for (int left = leftIndex; left < rightIndex; left += 2 * size) {
                int mid = left + size - 1;
                int right = Math.min(left + 2 * size - 1, rightIndex - 1);
                if (mid >= right) continue;
                MergeSorts.merge(arr, left, mid, right);
            }
        }
    }

    public static void timSort(Object[] arr, int leftIndex, int rightIndex) {
        int minRun = TimSorts.minRunLength(rightIndex - leftIndex);
        for (int i = leftIndex; i < rightIndex; i += minRun) {
            InsertionSorts.insertSort(arr, i, Math.min(i + 32 - 1, rightIndex - 1) + 1);
        }
        for (int size = minRun; size < rightIndex; size = 2 * size) {
            for (int left = leftIndex; left < rightIndex; left += 2 * size) {
                int mid = left + size - 1;
                int right = Math.min(left + 2 * size - 1, rightIndex - 1);
                if (mid >= right) continue;
                MergeSorts.merge(arr, left, mid, right);
            }
        }
    }

    public static <T> void timSort(T[] arr, int leftIndex, int rightIndex, Comparator<? super T> c) {
        int minRun = TimSorts.minRunLength(rightIndex - leftIndex);
        for (int i = leftIndex; i < rightIndex; i += minRun) {
            InsertionSorts.insertSort(arr, i, Math.min(i + 32 - 1, rightIndex - 1) + 1, c);
        }
        for (int size = minRun; size < rightIndex; size = 2 * size) {
            for (int left = leftIndex; left < rightIndex; left += 2 * size) {
                int mid = left + size - 1;
                int right = Math.min(left + 2 * size - 1, rightIndex - 1);
                if (mid >= right) continue;
                MergeSorts.merge(arr, left, mid, right, c);
            }
        }
    }

    @Override
    public void sort(byte[] a, int fromIndex, int toIndex) {
        TimSorts.timSort(a, fromIndex, toIndex);
    }

    @Override
    public void sort(short[] a, int fromIndex, int toIndex) {
        TimSorts.timSort(a, fromIndex, toIndex);
    }

    @Override
    public void sort(int[] a, int fromIndex, int toIndex) {
        TimSorts.timSort(a, fromIndex, toIndex);
    }

    @Override
    public void sort(long[] a, int fromIndex, int toIndex) {
        TimSorts.timSort(a, fromIndex, toIndex);
    }

    @Override
    public void sort(float[] a, int fromIndex, int toIndex) {
        TimSorts.timSort(a, fromIndex, toIndex);
    }

    @Override
    public void sort(double[] a, int fromIndex, int toIndex) {
        TimSorts.timSort(a, fromIndex, toIndex);
    }

    @Override
    public void sort(char[] a, int fromIndex, int toIndex) {
        TimSorts.timSort(a, fromIndex, toIndex);
    }

    @Override
    public void sort(Object[] a, int fromIndex, int toIndex) {
        TimSorts.timSort(a, fromIndex, toIndex);
    }

    @Override
    public <T> void sort(T[] a, int fromIndex, int toIndex, Comparator<? super T> c) {
        TimSorts.timSort(a, fromIndex, toIndex, c);
    }
}

