/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.sql.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SqlColumn {
    private final String className;
    private final int displaySize;
    private final String label;
    private final String name;
    private final int type;
    private final String typeName;

    @lombok.NonNull
    public static List<SqlColumn> allOf(@lombok.NonNull ResultSetMetaData md) throws SQLException {
        if (md == null) {
            throw new NullPointerException("md is marked non-null but is null");
        }
        SqlColumn[] result = new SqlColumn[md.getColumnCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = SqlColumn.of(md, i + 1);
        }
        return Arrays.asList(result);
    }

    @lombok.NonNull
    public static SqlColumn of(@lombok.NonNull ResultSetMetaData md, int columnIndex) throws SQLException {
        if (md == null) {
            throw new NullPointerException("md is marked non-null but is null");
        }
        return new SqlColumn(md.getColumnClassName(columnIndex), md.getColumnDisplaySize(columnIndex), md.getColumnLabel(columnIndex), md.getColumnName(columnIndex), md.getColumnType(columnIndex), md.getColumnTypeName(columnIndex));
    }

    @Generated
    SqlColumn(String className, int displaySize, String label, String name, int type, String typeName) {
        this.className = className;
        this.displaySize = displaySize;
        this.label = label;
        this.name = name;
        this.type = type;
        this.typeName = typeName;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public int getDisplaySize() {
        return this.displaySize;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getType() {
        return this.type;
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlColumn)) {
            return false;
        }
        SqlColumn other = (SqlColumn)o;
        if (this.getDisplaySize() != other.getDisplaySize()) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        return !(this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDisplaySize();
        result = result * 59 + this.getType();
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "SqlColumn(className=" + this.getClassName() + ", displaySize=" + this.getDisplaySize() + ", label=" + this.getLabel() + ", name=" + this.getName() + ", type=" + this.getType() + ", typeName=" + this.getTypeName() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private String className;
        @Generated
        private int displaySize;
        @Generated
        private String label;
        @Generated
        private String name;
        @Generated
        private int type;
        @Generated
        private String typeName;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder className(String className) {
            this.className = className;
            return this;
        }

        @Generated
        public @NonNull Builder displaySize(int displaySize) {
            this.displaySize = displaySize;
            return this;
        }

        @Generated
        public @NonNull Builder label(String label) {
            this.label = label;
            return this;
        }

        @Generated
        public @NonNull Builder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public @NonNull Builder type(int type) {
            this.type = type;
            return this;
        }

        @Generated
        public @NonNull Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        @Generated
        public @NonNull SqlColumn build() {
            return new SqlColumn(this.className, this.displaySize, this.label, this.name, this.type, this.typeName);
        }

        @Generated
        public @NonNull String toString() {
            return "SqlColumn.Builder(className=" + this.className + ", displaySize=" + this.displaySize + ", label=" + this.label + ", name=" + this.name + ", type=" + this.type + ", typeName=" + this.typeName + ")";
        }
    }
}

