/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.sql.jdbc;

import java.util.Locale;
import java.util.Objects;
import lombok.NonNull;

public enum SqlIdentifierStorageRule {
    UPPER{

        @Override
        public boolean isValid(@NonNull String identifier) {
            if (identifier == null) {
                throw new NullPointerException("identifier is marked non-null but is null");
            }
            return identifier.toUpperCase(Locale.ROOT).equals(identifier);
        }
    }
    ,
    LOWER{

        @Override
        public boolean isValid(@NonNull String identifier) {
            if (identifier == null) {
                throw new NullPointerException("identifier is marked non-null but is null");
            }
            return identifier.toLowerCase(Locale.ROOT).equals(identifier);
        }
    }
    ,
    MIXED{

        @Override
        public boolean isValid(@NonNull String identifier) {
            Objects.requireNonNull(identifier);
            return true;
        }
    };


    public abstract boolean isValid(@NonNull String var1);
}

