/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.sql.odbc;

import java.io.File;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.regex.Pattern;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class OdbcDriver {
    @lombok.NonNull
    private final String name;
    @lombok.NonNull
    private final ApiLevel apiLevel;
    private final ConnectFunctions connectFunctions;
    private final File driverPath;
    private final String driverOdbcVer;
    @lombok.NonNull
    private final List<String> fileExtensions;
    @lombok.NonNull
    private final FileUsage fileUsage;
    private final File setupPath;
    @lombok.NonNull
    private final SqlLevel sqlLevel;
    private final int usageCount;

    @Generated
    OdbcDriver(@lombok.NonNull String name, @lombok.NonNull ApiLevel apiLevel, ConnectFunctions connectFunctions, File driverPath, String driverOdbcVer, @lombok.NonNull List<String> fileExtensions, @lombok.NonNull FileUsage fileUsage, File setupPath, @lombok.NonNull SqlLevel sqlLevel, int usageCount) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (apiLevel == null) {
            throw new NullPointerException("apiLevel is marked non-null but is null");
        }
        if (fileExtensions == null) {
            throw new NullPointerException("fileExtensions is marked non-null but is null");
        }
        if (fileUsage == null) {
            throw new NullPointerException("fileUsage is marked non-null but is null");
        }
        if (sqlLevel == null) {
            throw new NullPointerException("sqlLevel is marked non-null but is null");
        }
        this.name = name;
        this.apiLevel = apiLevel;
        this.connectFunctions = connectFunctions;
        this.driverPath = driverPath;
        this.driverOdbcVer = driverOdbcVer;
        this.fileExtensions = fileExtensions;
        this.fileUsage = fileUsage;
        this.setupPath = setupPath;
        this.sqlLevel = sqlLevel;
        this.usageCount = usageCount;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @lombok.NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @lombok.NonNull
    @Generated
    public ApiLevel getApiLevel() {
        return this.apiLevel;
    }

    @Generated
    public ConnectFunctions getConnectFunctions() {
        return this.connectFunctions;
    }

    @Generated
    public File getDriverPath() {
        return this.driverPath;
    }

    @Generated
    public String getDriverOdbcVer() {
        return this.driverOdbcVer;
    }

    @lombok.NonNull
    @Generated
    public List<String> getFileExtensions() {
        return this.fileExtensions;
    }

    @lombok.NonNull
    @Generated
    public FileUsage getFileUsage() {
        return this.fileUsage;
    }

    @Generated
    public File getSetupPath() {
        return this.setupPath;
    }

    @lombok.NonNull
    @Generated
    public SqlLevel getSqlLevel() {
        return this.sqlLevel;
    }

    @Generated
    public int getUsageCount() {
        return this.usageCount;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OdbcDriver)) {
            return false;
        }
        OdbcDriver other = (OdbcDriver)o;
        if (this.getUsageCount() != other.getUsageCount()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ApiLevel this$apiLevel = this.getApiLevel();
        ApiLevel other$apiLevel = other.getApiLevel();
        if (this$apiLevel == null ? other$apiLevel != null : !this$apiLevel.equals(other$apiLevel)) {
            return false;
        }
        ConnectFunctions this$connectFunctions = this.getConnectFunctions();
        ConnectFunctions other$connectFunctions = other.getConnectFunctions();
        if (this$connectFunctions == null ? other$connectFunctions != null : !((Object)this$connectFunctions).equals(other$connectFunctions)) {
            return false;
        }
        File this$driverPath = this.getDriverPath();
        File other$driverPath = other.getDriverPath();
        if (this$driverPath == null ? other$driverPath != null : !((Object)this$driverPath).equals(other$driverPath)) {
            return false;
        }
        String this$driverOdbcVer = this.getDriverOdbcVer();
        String other$driverOdbcVer = other.getDriverOdbcVer();
        if (this$driverOdbcVer == null ? other$driverOdbcVer != null : !this$driverOdbcVer.equals(other$driverOdbcVer)) {
            return false;
        }
        List<String> this$fileExtensions = this.getFileExtensions();
        List<String> other$fileExtensions = other.getFileExtensions();
        if (this$fileExtensions == null ? other$fileExtensions != null : !((Object)this$fileExtensions).equals(other$fileExtensions)) {
            return false;
        }
        FileUsage this$fileUsage = this.getFileUsage();
        FileUsage other$fileUsage = other.getFileUsage();
        if (this$fileUsage == null ? other$fileUsage != null : !this$fileUsage.equals(other$fileUsage)) {
            return false;
        }
        File this$setupPath = this.getSetupPath();
        File other$setupPath = other.getSetupPath();
        if (this$setupPath == null ? other$setupPath != null : !((Object)this$setupPath).equals(other$setupPath)) {
            return false;
        }
        SqlLevel this$sqlLevel = this.getSqlLevel();
        SqlLevel other$sqlLevel = other.getSqlLevel();
        return !(this$sqlLevel == null ? other$sqlLevel != null : !this$sqlLevel.equals(other$sqlLevel));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getUsageCount();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ApiLevel $apiLevel = this.getApiLevel();
        result = result * 59 + ($apiLevel == null ? 43 : $apiLevel.hashCode());
        ConnectFunctions $connectFunctions = this.getConnectFunctions();
        result = result * 59 + ($connectFunctions == null ? 43 : ((Object)$connectFunctions).hashCode());
        File $driverPath = this.getDriverPath();
        result = result * 59 + ($driverPath == null ? 43 : ((Object)$driverPath).hashCode());
        String $driverOdbcVer = this.getDriverOdbcVer();
        result = result * 59 + ($driverOdbcVer == null ? 43 : $driverOdbcVer.hashCode());
        List<String> $fileExtensions = this.getFileExtensions();
        result = result * 59 + ($fileExtensions == null ? 43 : ((Object)$fileExtensions).hashCode());
        FileUsage $fileUsage = this.getFileUsage();
        result = result * 59 + ($fileUsage == null ? 43 : $fileUsage.hashCode());
        File $setupPath = this.getSetupPath();
        result = result * 59 + ($setupPath == null ? 43 : ((Object)$setupPath).hashCode());
        SqlLevel $sqlLevel = this.getSqlLevel();
        result = result * 59 + ($sqlLevel == null ? 43 : $sqlLevel.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "OdbcDriver(name=" + this.getName() + ", apiLevel=" + this.getApiLevel() + ", connectFunctions=" + this.getConnectFunctions() + ", driverPath=" + this.getDriverPath() + ", driverOdbcVer=" + this.getDriverOdbcVer() + ", fileExtensions=" + this.getFileExtensions() + ", fileUsage=" + this.getFileUsage() + ", setupPath=" + this.getSetupPath() + ", sqlLevel=" + this.getSqlLevel() + ", usageCount=" + this.getUsageCount() + ")";
    }

    public static enum ApiLevel implements IntSupplier
    {
        NONE(0),
        LEVEL1(1),
        LEVEL2(2);

        final int value;

        @Override
        @Deprecated
        public int getAsInt() {
            return this.toInt();
        }

        public int toInt() {
            return this.value;
        }

        public static @NonNull ApiLevel parse(int value) throws IllegalArgumentException {
            for (ApiLevel o : ApiLevel.values()) {
                if (o.value != value) continue;
                return o;
            }
            throw new IllegalArgumentException("Cannot parse " + value);
        }

        @Generated
        private ApiLevel(int value) {
            this.value = value;
        }
    }

    public static final class ConnectFunctions {
        private final boolean sqlConnect;
        private final boolean sqlDriverConnect;
        private final boolean sqlBrowseConnect;
        static final Pattern INPUT_PATTERN = Pattern.compile("([YN]){3}");

        public String toString() {
            return (this.sqlConnect ? "Y" : "N") + (this.sqlDriverConnect ? "Y" : "N") + (this.sqlBrowseConnect ? "Y" : "N");
        }

        public static @NonNull ConnectFunctions parse(@NonNull CharSequence input) throws IllegalArgumentException {
            if (!INPUT_PATTERN.matcher(input).matches()) {
                throw new IllegalArgumentException("Cannot parse '" + input + "'");
            }
            return new ConnectFunctions(input.charAt(0) == 'Y', input.charAt(1) == 'Y', input.charAt(2) == 'Y');
        }

        @Deprecated
        public static @Nullable ConnectFunctions parse(@NonNull CharSequence input, @Nullable ConnectFunctions defaultValue) {
            return INPUT_PATTERN.matcher(input).matches() ? new ConnectFunctions(input.charAt(0) == 'Y', input.charAt(1) == 'Y', input.charAt(2) == 'Y') : defaultValue;
        }

        @Generated
        private ConnectFunctions(boolean sqlConnect, boolean sqlDriverConnect, boolean sqlBrowseConnect) {
            this.sqlConnect = sqlConnect;
            this.sqlDriverConnect = sqlDriverConnect;
            this.sqlBrowseConnect = sqlBrowseConnect;
        }

        @Generated
        public static @NonNull ConnectFunctions of(boolean sqlConnect, boolean sqlDriverConnect, boolean sqlBrowseConnect) {
            return new ConnectFunctions(sqlConnect, sqlDriverConnect, sqlBrowseConnect);
        }

        @Generated
        public boolean isSqlConnect() {
            return this.sqlConnect;
        }

        @Generated
        public boolean isSqlDriverConnect() {
            return this.sqlDriverConnect;
        }

        @Generated
        public boolean isSqlBrowseConnect() {
            return this.sqlBrowseConnect;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConnectFunctions)) {
                return false;
            }
            ConnectFunctions other = (ConnectFunctions)o;
            if (this.isSqlConnect() != other.isSqlConnect()) {
                return false;
            }
            if (this.isSqlDriverConnect() != other.isSqlDriverConnect()) {
                return false;
            }
            return this.isSqlBrowseConnect() == other.isSqlBrowseConnect();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSqlConnect() ? 79 : 97);
            result = result * 59 + (this.isSqlDriverConnect() ? 79 : 97);
            result = result * 59 + (this.isSqlBrowseConnect() ? 79 : 97);
            return result;
        }
    }

    public static enum FileUsage implements IntSupplier
    {
        NONE(0),
        TABLE(1),
        CATALOG(2);

        final int value;

        public boolean isFileBased() {
            return this != NONE;
        }

        @Override
        @Deprecated
        public int getAsInt() {
            return this.toInt();
        }

        public int toInt() {
            return this.value;
        }

        public static @NonNull FileUsage parse(int value) throws IllegalArgumentException {
            for (FileUsage o : FileUsage.values()) {
                if (o.value != value) continue;
                return o;
            }
            throw new IllegalArgumentException("Cannot parse " + value);
        }

        @Generated
        private FileUsage(int value) {
            this.value = value;
        }
    }

    public static enum SqlLevel implements IntSupplier
    {
        SQL_92_ENTRY(0),
        FIPS127_2_TRANSACTIONAL(1),
        SQL_92_INTERMEDIATE(2),
        SQL_92_FULL(3);

        final int value;

        @Override
        @Deprecated
        public int getAsInt() {
            return this.toInt();
        }

        public int toInt() {
            return this.value;
        }

        public static @NonNull SqlLevel parse(int value) throws IllegalArgumentException {
            for (SqlLevel o : SqlLevel.values()) {
                if (o.value != value) continue;
                return o;
            }
            throw new IllegalArgumentException("Cannot parse " + value);
        }

        @Generated
        private SqlLevel(int value) {
            this.value = value;
        }
    }

    @Generated
    public static class Builder {
        @Generated
        private String name;
        @Generated
        private ApiLevel apiLevel;
        @Generated
        private ConnectFunctions connectFunctions;
        @Generated
        private File driverPath;
        @Generated
        private String driverOdbcVer;
        @Generated
        private List<String> fileExtensions;
        @Generated
        private FileUsage fileUsage;
        @Generated
        private File setupPath;
        @Generated
        private SqlLevel sqlLevel;
        @Generated
        private int usageCount;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder name(@lombok.NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public @NonNull Builder apiLevel(@lombok.NonNull ApiLevel apiLevel) {
            if (apiLevel == null) {
                throw new NullPointerException("apiLevel is marked non-null but is null");
            }
            this.apiLevel = apiLevel;
            return this;
        }

        @Generated
        public @NonNull Builder connectFunctions(ConnectFunctions connectFunctions) {
            this.connectFunctions = connectFunctions;
            return this;
        }

        @Generated
        public @NonNull Builder driverPath(File driverPath) {
            this.driverPath = driverPath;
            return this;
        }

        @Generated
        public @NonNull Builder driverOdbcVer(String driverOdbcVer) {
            this.driverOdbcVer = driverOdbcVer;
            return this;
        }

        @Generated
        public @NonNull Builder fileExtensions(@lombok.NonNull List<String> fileExtensions) {
            if (fileExtensions == null) {
                throw new NullPointerException("fileExtensions is marked non-null but is null");
            }
            this.fileExtensions = fileExtensions;
            return this;
        }

        @Generated
        public @NonNull Builder fileUsage(@lombok.NonNull FileUsage fileUsage) {
            if (fileUsage == null) {
                throw new NullPointerException("fileUsage is marked non-null but is null");
            }
            this.fileUsage = fileUsage;
            return this;
        }

        @Generated
        public @NonNull Builder setupPath(File setupPath) {
            this.setupPath = setupPath;
            return this;
        }

        @Generated
        public @NonNull Builder sqlLevel(@lombok.NonNull SqlLevel sqlLevel) {
            if (sqlLevel == null) {
                throw new NullPointerException("sqlLevel is marked non-null but is null");
            }
            this.sqlLevel = sqlLevel;
            return this;
        }

        @Generated
        public @NonNull Builder usageCount(int usageCount) {
            this.usageCount = usageCount;
            return this;
        }

        @Generated
        public @NonNull OdbcDriver build() {
            return new OdbcDriver(this.name, this.apiLevel, this.connectFunctions, this.driverPath, this.driverOdbcVer, this.fileExtensions, this.fileUsage, this.setupPath, this.sqlLevel, this.usageCount);
        }

        @Generated
        public @NonNull String toString() {
            return "OdbcDriver.Builder(name=" + this.name + ", apiLevel=" + this.apiLevel + ", connectFunctions=" + this.connectFunctions + ", driverPath=" + this.driverPath + ", driverOdbcVer=" + this.driverOdbcVer + ", fileExtensions=" + this.fileExtensions + ", fileUsage=" + this.fileUsage + ", setupPath=" + this.setupPath + ", sqlLevel=" + this.sqlLevel + ", usageCount=" + this.usageCount + ")";
        }
    }
}

