/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.sql.odbc;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class OdbcConnectionString {
    @NonNull
    private final Map<String, String> attributes;
    private static final String DRIVER_KEYWORD = "DRIVER";
    private static final Pattern KEY_VALUE = Pattern.compile("(\\w+)=\\{*((?<=\\{)[^\\{\\}]+(?=\\})|[^\\s;]+)\\}*;?");

    public @Nullable String getDriver() {
        return this.get(DRIVER_KEYWORD);
    }

    public @Nullable String get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.attributes.entrySet().stream().filter(o -> ((String)o.getKey()).equalsIgnoreCase(key)).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<String, String>> iter = this.attributes.entrySet().iterator();
        if (iter.hasNext()) {
            Map.Entry<String, String> o = iter.next();
            OdbcConnectionString.append(result, o);
            while (iter.hasNext()) {
                o = iter.next();
                result.append(";");
                OdbcConnectionString.append(result, o);
            }
        }
        return result.toString();
    }

    private static void append(StringBuilder b, Map.Entry<String, String> o) {
        if (o.getKey().equalsIgnoreCase(DRIVER_KEYWORD)) {
            b.append(o.getKey()).append("={").append(o.getValue()).append("}");
        } else {
            b.append(o.getKey()).append("=").append(o.getValue());
        }
    }

    @NonNull
    public static OdbcConnectionString parse(@NonNull CharSequence input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        Builder result = OdbcConnectionString.builder();
        Matcher m = KEY_VALUE.matcher(input);
        while (m.find()) {
            result.with(m.group(1), m.group(2));
        }
        return result.build();
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OdbcConnectionString)) {
            return false;
        }
        OdbcConnectionString other = (OdbcConnectionString)o;
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @Generated
    private OdbcConnectionString(@NonNull Map<String, String> attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        this.attributes = attributes;
    }

    public static final class Builder {
        private final LinkedHashSet<String> order = new LinkedHashSet();
        private final TreeMap<String, String> attributes = new TreeMap(String.CASE_INSENSITIVE_ORDER);

        @NonNull
        public Builder with(@NonNull String key, @NonNull String value) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.order.add(key);
            this.attributes.put(key, value);
            return this;
        }

        @NonNull
        public OdbcConnectionString build() {
            LinkedHashMap result = new LinkedHashMap();
            this.order.forEach(o -> result.put(o, this.attributes.get(o)));
            return new OdbcConnectionString(Collections.unmodifiableMap(result));
        }

        @Generated
        private Builder() {
        }
    }
}

