/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.sql.odbc;

import internal.sql.odbc.FailsafeOdbcRegistry;
import internal.sql.odbc.OdbcRegistrySpiLoader;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nbbrd.sql.odbc.OdbcDataSource;
import nbbrd.sql.odbc.OdbcDriver;
import nbbrd.sql.odbc.OdbcRegistrySpi;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class OdbcRegistry {
    @lombok.NonNull
    private final OdbcRegistrySpi spi;

    @lombok.NonNull
    public static Optional<OdbcRegistry> ofServiceLoader() {
        return OdbcRegistrySpiLoader.load().map(FailsafeOdbcRegistry::wrap).map(OdbcRegistry::new);
    }

    @lombok.NonNull
    public String getName() {
        return this.spi.getName();
    }

    @lombok.NonNull
    public List<String> getDataSourceNames(OdbcDataSource.Type ... types) throws IOException {
        return this.spi.getDataSourceNames(types);
    }

    @lombok.NonNull
    public List<OdbcDataSource> getDataSources(OdbcDataSource.Type ... types) throws IOException {
        return this.spi.getDataSources(types);
    }

    @lombok.NonNull
    public List<String> getDriverNames() throws IOException {
        return this.spi.getDriverNames();
    }

    @lombok.NonNull
    public List<OdbcDriver> getDrivers() throws IOException {
        return this.spi.getDrivers();
    }

    @Generated
    private OdbcRegistry(@lombok.NonNull OdbcRegistrySpi spi) {
        if (spi == null) {
            throw new NullPointerException("spi is marked non-null but is null");
        }
        this.spi = spi;
    }

    @Generated
    public static @NonNull OdbcRegistry of(@lombok.NonNull OdbcRegistrySpi spi) {
        if (spi == null) {
            throw new NullPointerException("spi is marked non-null but is null");
        }
        return new OdbcRegistry(spi);
    }
}

