/*
 * Decompiled with CFR 0.152.
 */
package com.alon.querydecoder;

import com.alon.querydecoder.Decoder;
import com.alon.querydecoder.Expression;
import com.alon.querydecoder.LogicalOperator;

public class Group
implements Decoder {
    protected Decoder decoder;
    protected LogicalOperator logicalOperator;
    protected Decoder next;

    public Group(String query) {
        this.parse(query);
    }

    public Decoder getDecoder() {
        return this.decoder;
    }

    @Override
    public LogicalOperator getLogicalOperator() {
        return this.logicalOperator;
    }

    @Override
    public Decoder getNext() {
        return this.next;
    }

    public final Group parse(String expression) {
        this.checkIfStartsWithParetheses(expression);
        int opened = 0;
        int closed = 0;
        StringBuilder strBuilder = new StringBuilder();
        expression = this.normalize(expression);
        for (int i = 0; i < expression.length(); ++i) {
            char currentChar = expression.charAt(i);
            strBuilder.append(currentChar);
            if (currentChar == '(') {
                ++opened;
            } else if (currentChar == ')') {
                ++closed;
            }
            if (opened != closed) continue;
            String currentExpression = this.removeParentheses(strBuilder.toString());
            if (currentExpression.startsWith("(")) {
                this.decoder = new Group(currentExpression);
                break;
            }
            this.decoder = new Expression(currentExpression);
            break;
        }
        this.checkParenthesesCount(opened, closed);
        expression = this.removeParsedGroup(expression, strBuilder.toString());
        if (!expression.isBlank()) {
            this.logicalOperator = this.determineLogicalOperator(expression);
            this.next = (expression = this.removeLogicalOperatorFromStart(expression)).startsWith("(") ? new Group(expression) : new Expression(expression);
        }
        return this;
    }

    private void checkIfStartsWithParetheses(String expression) {
        if (!expression.startsWith("(")) {
            throw new IllegalArgumentException("A group must start with parentheses");
        }
    }

    private void checkParenthesesCount(int opened, int closed) {
        if (opened > closed) {
            throw new IllegalArgumentException("The expression is incorrect. There are more open parentheses than closed parentheses.");
        }
    }

    private String normalize(String expression) {
        return expression.replace(" and ", " AND ").replace(" or ", " OR ").trim();
    }

    private String removeParentheses(String expression) {
        return expression.substring(0, expression.length() - 1).substring(1);
    }

    private String removeParsedGroup(String expression, String parsedGroup) {
        return expression.substring(parsedGroup.length()).trim();
    }

    private LogicalOperator determineLogicalOperator(String expression) {
        if (expression.startsWith(LogicalOperator.AND.name())) {
            return LogicalOperator.AND;
        }
        return LogicalOperator.OR;
    }

    private String removeLogicalOperatorFromStart(String expression) {
        if (expression.startsWith(LogicalOperator.AND.name())) {
            return expression.substring(4).trim();
        }
        if (expression.startsWith(LogicalOperator.OR.name())) {
            return expression.substring(3).trim();
        }
        return expression;
    }

    public String toString() {
        String result = String.format("(%s)", this.decoder);
        if (this.next != null) {
            result = String.format("%s %s %s", new Object[]{result, this.logicalOperator, this.next});
        }
        return result;
    }
}

