/*
 * Decompiled with CFR 0.152.
 */
package com.alon.querydecoder;

import com.alon.querydecoder.Decoder;
import com.alon.querydecoder.Expression;
import com.alon.querydecoder.Group;
import java.util.function.Function;

public class QueryDecoder<T> {
    protected Decoder decoder;
    private Function<Decoder, T> decodeFunction;

    public QueryDecoder(String query) {
        this.decoder = this.createDecoder(query);
    }

    public QueryDecoder(String query, Function<Decoder, T> decodeFunction) {
        this(query);
        this.decodeFunction = decodeFunction;
    }

    public Decoder getDecoder() {
        return this.decoder;
    }

    private Decoder createDecoder(String query) {
        if (query.startsWith("(")) {
            return new Group(query);
        }
        return new Expression(query);
    }

    public T decode() {
        if (this.decodeFunction == null) {
            throw new UnsupportedOperationException("The decoding function has not been entered.");
        }
        return this.decodeFunction.apply(this.decoder);
    }

    public T decode(Function<Decoder, T> decodeFunction) {
        this.decodeFunction = decodeFunction;
        return this.decode();
    }
}

