/*
 * Decompiled with CFR 0.152.
 */
package com.alon.querydecoder.impl;

import com.alon.querydecoder.Decoder;
import com.alon.querydecoder.Expression;
import com.alon.querydecoder.Group;
import com.alon.querydecoder.LogicalOperator;
import com.alon.querydecoder.QueryDecoder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class SpringJpaSpecificationDecoder<T>
extends QueryDecoder<Predicate>
implements Specification<T> {
    public SpringJpaSpecificationDecoder(String query) {
        super(query, SpringJpaSpecificationDecoder::decode);
    }

    private static Predicate decode(Decoder group) {
        throw new UnsupportedOperationException("This operation is unsupported. This decoder was implemented to work in conjunction with org.springframework.data.jpa.repository.JpaSpecificationExecutor methods.");
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
        return this.decode(root, criteriaBuilder);
    }

    public Predicate decode(Root<T> root, CriteriaBuilder criteriaBuilder) {
        if (this.decoder instanceof Group) {
            return this.decode((Group)this.decoder, root, criteriaBuilder);
        }
        return this.decode((Expression)this.decoder, root, criteriaBuilder);
    }

    private Predicate decode(Group group, Root<T> root, CriteriaBuilder criteriaBuilder) {
        Predicate predicate = this.decode(group.getDecoder(), root, criteriaBuilder);
        return this.decodeNext(predicate, group, root, criteriaBuilder);
    }

    private Predicate decode(Expression expression, Root<T> root, CriteriaBuilder criteriaBuilder) {
        Predicate predicate;
        Path<T> path = this.getPath((Path<?>)root, (List<String>)new ArrayList<String>(Arrays.asList(expression.getField().split("\\."))));
        switch (expression.getMatchType()) {
            case BT: {
                String[] values = expression.getValue().split("-");
                if (path.getJavaType().equals(Long.class)) {
                    predicate = criteriaBuilder.between(path, (Comparable)Long.valueOf(values[0]), (Comparable)Long.valueOf(values[1]));
                    break;
                }
                predicate = criteriaBuilder.between(path, (Comparable)((Object)values[0]), (Comparable)((Object)values[1]));
                break;
            }
            case CT: {
                predicate = criteriaBuilder.like(path, "%".concat(expression.getValue()).concat("%"));
                break;
            }
            case EQ: {
                predicate = criteriaBuilder.equal(path, (Object)expression.getValue());
                break;
            }
            case GT: {
                predicate = criteriaBuilder.gt(path, (Number)new BigDecimal(expression.getValue()));
                break;
            }
            case GTE: {
                predicate = criteriaBuilder.greaterThanOrEqualTo(path, (Comparable)new BigDecimal(expression.getValue()));
                break;
            }
            case LT: {
                predicate = criteriaBuilder.le(path, (Number)new BigDecimal(expression.getValue()));
                break;
            }
            case LTE: {
                predicate = criteriaBuilder.lessThanOrEqualTo(path, (Comparable)new BigDecimal(expression.getValue()));
                break;
            }
            case IN: {
                predicate = path.in(Arrays.asList(expression.getValue().split(",")));
                break;
            }
            default: {
                predicate = criteriaBuilder.equal(path, (Object)expression.getValue());
            }
        }
        return this.decodeNext(predicate, expression, root, criteriaBuilder);
    }

    private Predicate decode(Decoder decoder, Root<T> root, CriteriaBuilder criteriaBuilder) {
        if (decoder instanceof Group) {
            return this.decode((Group)decoder, root, criteriaBuilder);
        }
        return this.decode((Expression)decoder, root, criteriaBuilder);
    }

    private Predicate decodeNext(Predicate predicate, Decoder decoder, Root<T> root, CriteriaBuilder criteriaBuilder) {
        if (decoder.getNext() == null) {
            return predicate;
        }
        Predicate nextPredicate = this.decode(decoder.getNext(), root, criteriaBuilder);
        if (decoder.getLogicalOperator().equals((Object)LogicalOperator.AND)) {
            return criteriaBuilder.and((javax.persistence.criteria.Expression)predicate, (javax.persistence.criteria.Expression)nextPredicate);
        }
        return criteriaBuilder.or((javax.persistence.criteria.Expression)predicate, (javax.persistence.criteria.Expression)nextPredicate);
    }

    private Path<?> getPath(Path<?> parent, List<String> props) {
        Path p = parent.get(props.remove(0));
        if (!props.isEmpty()) {
            return this.getPath(p, props);
        }
        return p;
    }
}

