/*
 * Decompiled with CFR 0.152.
 */
package com.protobufel.multikeymap;

import com.protobufel.multikeymap.Collectors;
import com.protobufel.multikeymap.LiteSetMultimap;
import com.protobufel.multikeymap.MultiKeyMap;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;

class BaseMultiKeyMap<T, K extends Iterable<T>, V>
implements MultiKeyMap<T, K, V> {
    static boolean enableParallelStreaming = false;
    private Map<K, V> fullMap;
    private transient LiteSetMultimap<T, K> partMap;
    private transient Set<K> keySet;
    private transient Collection<V> values;
    private transient Set<Map.Entry<K, V>> entrySet;

    static final boolean isEnableParallelStreaming() {
        return enableParallelStreaming;
    }

    static final void setEnableParallelStreaming(boolean enableParallelStreaming) {
        BaseMultiKeyMap.enableParallelStreaming = enableParallelStreaming;
    }

    BaseMultiKeyMap(Map<K, V> fullMap, LiteSetMultimap<T, K> partMap) {
        this.fullMap = fullMap;
        this.partMap = partMap;
    }

    BaseMultiKeyMap() {
        this(new HashMap(), LiteSetMultimap.newInstance());
    }

    public String toString() {
        return this.fullMap.toString();
    }

    @Override
    public Stream<K> getFullKeysByPartialKey(Iterable<? extends T> partialKey) {
        Objects.requireNonNull(partialKey);
        if (this.partMap.isEmpty()) {
            return Stream.empty();
        }
        if (!(partialKey instanceof Set)) {
            return this.getFullKeysByPartialKey(partialKey, Collections.emptyList());
        }
        ArrayList<Set<K>> sets = new ArrayList<Set<K>>();
        for (T subKey : partialKey) {
            Set<K> set2 = this.partMap.get(Objects.requireNonNull(subKey));
            if (set2 == null) {
                return Stream.empty();
            }
            sets.add(set2);
        }
        if (sets.isEmpty()) {
            return Stream.empty();
        }
        return Collectors.intersectSets(sets, BaseMultiKeyMap.isEnableParallelStreaming()).map(set -> set.stream()).orElse(Stream.empty());
    }

    @Override
    public int size() {
        return this.fullMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.fullMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.fullMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.fullMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.fullMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        Objects.requireNonNull(value);
        Object[] oldValue = new Object[]{null};
        this.fullMap.compute((Iterable)key, (k, v) -> {
            if (v == null) {
                this.putPartial(k);
            } else {
                oldValue[0] = v;
            }
            return value;
        });
        Object oldV = oldValue[0];
        return (V)oldV;
    }

    @Override
    public V remove(Object key) {
        Iterable fullKey = (Iterable)key;
        Object[] oldValue = new Object[]{null};
        this.fullMap.computeIfPresent(fullKey, (k, v) -> {
            this.deletePartial(k);
            oldValue[0] = v;
            return null;
        });
        Object oldV = oldValue[0];
        return (V)oldV;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : Objects.requireNonNull(m).entrySet()) {
            this.put((K)((Iterable)entry.getKey()), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.fullMap.clear();
        this.partMap.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.fullMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.fullMap.hashCode();
    }

    private void putPartial(K key) {
        for (Object subKey : key) {
            this.partMap.put(subKey, key);
        }
    }

    private void deletePartial(K key) {
        for (Object subKey : key) {
            this.partMap.remove(subKey, key);
        }
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    final class EntrySetIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> it;
        private Map.Entry<K, V> current;

        public EntrySetIterator(Iterator<Map.Entry<K, V>> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.it.next();
            return this.current;
        }

        @Override
        public void remove() {
            this.it.remove();
            BaseMultiKeyMap.this.deletePartial((Iterable)this.current.getKey());
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator(BaseMultiKeyMap.this.fullMap.entrySet().iterator());
        }

        @Override
        public int size() {
            return BaseMultiKeyMap.this.fullMap.size();
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return BaseMultiKeyMap.this.fullMap.entrySet().spliterator();
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<K, V>> action) {
            BaseMultiKeyMap.this.fullMap.entrySet().forEach(action);
        }

        @Override
        public boolean contains(Object o) {
            return BaseMultiKeyMap.this.fullMap.entrySet().contains(o);
        }

        @Override
        public boolean remove(Object o) {
            if (BaseMultiKeyMap.this.fullMap.entrySet().remove(o)) {
                Map.Entry entry = (Map.Entry)o;
                BaseMultiKeyMap.this.deletePartial((Iterable)entry.getKey());
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            BaseMultiKeyMap.this.clear();
        }
    }

    final class KeySetIterator
    implements Iterator<K> {
        private final Iterator<K> it;
        private K current;

        public KeySetIterator(Iterator<K> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public K next() {
            this.current = (Iterable)this.it.next();
            return this.current;
        }

        @Override
        public void remove() {
            this.it.remove();
            BaseMultiKeyMap.this.deletePartial(this.current);
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator(BaseMultiKeyMap.this.fullMap.keySet().iterator());
        }

        @Override
        public int size() {
            return BaseMultiKeyMap.this.fullMap.size();
        }

        @Override
        public Spliterator<K> spliterator() {
            return BaseMultiKeyMap.this.fullMap.keySet().spliterator();
        }

        @Override
        public void forEach(Consumer<? super K> action) {
            BaseMultiKeyMap.this.fullMap.keySet().forEach(action);
        }

        @Override
        public boolean contains(Object o) {
            return BaseMultiKeyMap.this.fullMap.keySet().contains(o);
        }

        @Override
        public boolean remove(Object o) {
            if (BaseMultiKeyMap.this.fullMap.keySet().remove(o)) {
                Iterable key = (Iterable)o;
                BaseMultiKeyMap.this.deletePartial(key);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            BaseMultiKeyMap.this.clear();
        }
    }

    final class ValueIterator
    implements Iterator<V> {
        private final Iterator<Map.Entry<K, V>> it;
        private Map.Entry<K, V> current;

        public ValueIterator(Iterator<Map.Entry<K, V>> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public V next() {
            this.current = this.it.next();
            return this.current.getValue();
        }

        @Override
        public void remove() {
            this.it.remove();
            BaseMultiKeyMap.this.deletePartial((Iterable)this.current.getKey());
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(BaseMultiKeyMap.this.fullMap.entrySet().iterator());
        }

        @Override
        public int size() {
            return BaseMultiKeyMap.this.fullMap.size();
        }

        @Override
        public Spliterator<V> spliterator() {
            return BaseMultiKeyMap.this.fullMap.values().spliterator();
        }

        @Override
        public void forEach(Consumer<? super V> action) {
            BaseMultiKeyMap.this.fullMap.values().forEach(action);
        }

        @Override
        public boolean contains(Object o) {
            return BaseMultiKeyMap.this.fullMap.values().contains(o);
        }

        @Override
        public void clear() {
            BaseMultiKeyMap.this.clear();
        }
    }
}

