/*
 * Decompiled with CFR 0.152.
 */
package com.protobufel.multikeymap;

import com.protobufel.multikeymap.MultiKeyMap;
import com.protobufel.multikeymap.MultiKeyMaps;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

final class Collectors {
    private Collectors() {
    }

    public static <K> Optional<Set<K>> intersectSets(Iterable<? extends Set<K>> source, boolean parallel) {
        return ((Stream)StreamSupport.stream(Objects.requireNonNull(source).spliterator(), parallel).unordered()).min(Comparator.comparingInt(set -> Objects.requireNonNull(set).size())).map(smallestSet -> ((Stream)StreamSupport.stream(source.spliterator(), parallel).unordered()).collect(Collectors.setIntersecting(smallestSet, parallel)));
    }

    public static <K> Collector<Set<K>, Set<K>, Set<K>> setIntersecting(Set<K> smallestSet, boolean parallel) {
        return Collectors.setIntersecting(() -> smallestSet, parallel);
    }

    public static <K> Collector<Set<K>, Set<K>, Set<K>> setIntersecting(Supplier<Set<K>> smallestSetSupplier, boolean parallel) {
        return parallel ? new ConcurrentSetIntersecting<K>(smallestSetSupplier) : new SequentialSetIntersecting<K>(smallestSetSupplier);
    }

    public static <T, E, K extends Iterable<E>, U> Collector<T, ?, MultiKeyMap<E, K, U>> toMultiKeyMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return java.util.stream.Collectors.toMap(keyMapper, valueMapper, (k, v) -> {
            throw new IllegalStateException(String.format("duplicate key %s", k));
        }, MultiKeyMaps::newMultiKeyMap);
    }

    public static <T, E, K extends Iterable<E>, U> Collector<T, ?, MultiKeyMap<E, K, U>> toMultiKeyMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return java.util.stream.Collectors.toMap(keyMapper, valueMapper, mergeFunction, MultiKeyMaps::newMultiKeyMap);
    }

    public static <T, E, K extends Iterable<E>, U, M extends MultiKeyMap<E, K, U>> Collector<T, ?, M> toMultiKeyMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> multiKeyMapSupplier) {
        return java.util.stream.Collectors.toMap(keyMapper, valueMapper, mergeFunction, multiKeyMapSupplier);
    }

    static final class SequentialSetIntersecting<K>
    implements Collector<Set<K>, Set<K>, Set<K>> {
        private final Supplier<Set<K>> smallestSetSupplier;

        SequentialSetIntersecting(Supplier<Set<K>> smallestSetSupplier) {
            this.smallestSetSupplier = Objects.requireNonNull(smallestSetSupplier);
        }

        @Override
        public Supplier<Set<K>> supplier() {
            return () -> new HashSet(this.smallestSetSupplier.get());
        }

        @Override
        public BiConsumer<Set<K>, Set<K>> accumulator() {
            return (set1, set2) -> {
                if (set2 != this.smallestSetSupplier.get() && !set1.isEmpty() && !set2.isEmpty()) {
                    set1.retainAll((Collection<?>)set2);
                }
            };
        }

        @Override
        public BinaryOperator<Set<K>> combiner() {
            return (set1, set2) -> set1.isEmpty() || set2.isEmpty() || set1.retainAll((Collection<?>)set2) && set1.isEmpty() ? Collections.emptySet() : set1;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH, Collector.Characteristics.UNORDERED));
        }

        @Override
        public Function<Set<K>, Set<K>> finisher() {
            return Function.identity();
        }
    }

    static final class ConcurrentSetIntersecting<K>
    implements Collector<Set<K>, Set<K>, Set<K>> {
        private final Supplier<Set<K>> smallestSetSupplier;

        ConcurrentSetIntersecting(Supplier<Set<K>> smallestSetSupplier) {
            this.smallestSetSupplier = Objects.requireNonNull(smallestSetSupplier);
        }

        @Override
        public Supplier<Set<K>> supplier() {
            return () -> {
                Set<K> smallestSet = this.smallestSetSupplier.get();
                ConcurrentHashMap.KeySetView<K, Boolean> newKeySet = ConcurrentHashMap.newKeySet(smallestSet.size());
                newKeySet.addAll((Collection<K>)smallestSet);
                return newKeySet;
            };
        }

        @Override
        public BiConsumer<Set<K>, Set<K>> accumulator() {
            return (set1, set2) -> {
                if (set2 != this.smallestSetSupplier.get() && !set1.isEmpty() && !set2.isEmpty()) {
                    set1.retainAll((Collection<?>)set2);
                }
            };
        }

        @Override
        public BinaryOperator<Set<K>> combiner() {
            return (set1, set2) -> set1.isEmpty() || set2.isEmpty() || set1.retainAll((Collection<?>)set2) && set1.isEmpty() ? Collections.emptySet() : set1;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.unmodifiableSet(EnumSet.allOf(Collector.Characteristics.class));
        }

        @Override
        public Function<Set<K>, Set<K>> finisher() {
            return Function.identity();
        }
    }
}

