/*
 * Decompiled with CFR 0.152.
 */
package com.protobufel.multikeymap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public interface LiteSetMultimap<K, V> {
    public void clear();

    public boolean remove(K var1, V var2);

    public int size();

    public boolean isEmpty();

    public Set<V> get(K var1);

    public boolean put(K var1, V var2);

    public static <K, V> LiteSetMultimap<K, V> newInstance() {
        return LiteSetMultimap.newInstance(new HashMap());
    }

    public static <K, V> LiteSetMultimap<K, V> newInstance(final Map<K, Set<V>> map) {
        return new LiteSetMultimap<K, V>(){

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public boolean isEmpty() {
                return map.isEmpty();
            }

            @Override
            public Set<V> get(Object key) {
                return (Set)map.get(key);
            }

            @Override
            public boolean put(K key, V value) {
                return map.computeIfAbsent(Objects.requireNonNull(key), k -> new HashSet()).add(Objects.requireNonNull(value));
            }

            @Override
            public void clear() {
                map.clear();
            }

            public boolean equals(Object o) {
                return map.equals(o);
            }

            public int hashCode() {
                return map.hashCode();
            }

            @Override
            public boolean remove(K key, V value) {
                boolean[] removed = new boolean[]{false};
                map.computeIfPresent(Objects.requireNonNull(key), (k, v) -> {
                    removed[0] = v.remove(value);
                    if (removed[0] && v.isEmpty()) {
                        return null;
                    }
                    return v;
                });
                return removed[0];
            }
        };
    }
}

