/*
 * Decompiled with CFR 0.152.
 */
package com.protobufel.multikeymap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

final class Matchers {
    private Matchers() {
    }

    public static <T> boolean matchesByPositions(Iterable<? extends Iterable<? extends T>> source, Iterable<? extends T> search, Iterable<Integer> positions) {
        Objects.requireNonNull(source);
        IterablePositionMatcher<T> matcher = new IterablePositionMatcher<T>(Objects.requireNonNull(search), Objects.requireNonNull(positions));
        for (Iterable<T> iterable : source) {
            if (matcher.matches(iterable)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean matchesByPositionalPattern(Iterable<? extends Iterable<? extends T>> source, Iterable<? extends T> search, Pattern pattern) {
        Objects.requireNonNull(source);
        IterablePatternMatcher<T> matcher = new IterablePatternMatcher<T>(Objects.requireNonNull(search), Objects.requireNonNull(pattern));
        for (Iterable<T> iterable : source) {
            if (matcher.matches(iterable)) continue;
            return false;
        }
        return true;
    }

    static class IterablePatternMatcher<T> {
        final Map<T, String> symbols;
        final Pattern pattern;

        IterablePatternMatcher(Iterable<? extends T> search, Pattern pattern) {
            Objects.requireNonNull(search);
            this.pattern = Objects.requireNonNull(pattern);
            this.symbols = new HashMap<T, String>();
            int i = 0;
            for (T el : search) {
                int n = i;
                i = (short)(i + 1);
                this.symbols.put(el, String.valueOf(n));
            }
        }

        boolean matches(Iterable<? extends T> source) {
            return this.matches(source, this.pattern);
        }

        boolean matches(Iterable<? extends T> source, Pattern pattern) {
            Objects.requireNonNull(pattern);
            String s = StreamSupport.stream(Objects.requireNonNull(source).spliterator(), false).collect(Collectors.mapping(x -> this.symbols.getOrDefault(x, ""), Collectors.joining(",")));
            return pattern.matcher(s).matches();
        }
    }

    static class IterablePositionMatcher<T> {
        final Map<T, Set<Integer>> symbols;
        final Map<T, Integer> counters;
        final int totalCount;

        IterablePositionMatcher(Iterable<? extends T> search, Iterable<Integer> positions) {
            Objects.requireNonNull(search);
            Objects.requireNonNull(positions);
            this.symbols = new HashMap<T, Set<Integer>>();
            this.counters = new HashMap<T, Integer>();
            Iterator<Integer> it = positions.iterator();
            boolean morePositions = true;
            int totalCount = 0;
            for (T el : search) {
                ++totalCount;
                this.counters.merge(el, 1, (oldValue, value) -> oldValue + 1);
                if (!morePositions || !(morePositions = it.hasNext())) continue;
                int position = it.next();
                this.symbols.computeIfAbsent(el, k -> new HashSet()).add(position);
            }
            this.totalCount = totalCount;
        }

        boolean matches(Iterable<? extends T> source) {
            Objects.requireNonNull(source);
            HashMap<T, Integer> counters = new HashMap<T, Integer>(this.counters);
            int totalCount = this.totalCount;
            int i = -1;
            for (T el : source) {
                Set<Integer> fixedPositions = this.symbols.get(el);
                if (fixedPositions != null && fixedPositions.contains(++i)) {
                    if (--totalCount != 0) continue;
                    return true;
                }
                int counter = counters.getOrDefault(el, -1);
                if (counter < 0) continue;
                if (--totalCount == 0) {
                    return true;
                }
                if (counter == 1) {
                    counters.remove(el);
                    continue;
                }
                counters.put(el, counter - 1);
            }
            return totalCount == 0;
        }
    }
}

