/*
 * Decompiled with CFR 0.152.
 */
package com.protobufel.multikeymap;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface MultiKeyMap<T, K extends Iterable<T>, V>
extends Map<K, V> {
    public Stream<K> getFullKeysByPartialKey(Iterable<? extends T> var1);

    default public Stream<V> getValuesByPartialKey(Iterable<? extends T> partialKey) {
        return this.getFullKeysByPartialKey(Objects.requireNonNull(partialKey)).map(key -> this.get(key));
    }

    default public Stream<Map.Entry<K, V>> getEntriesByPartialKey(Iterable<? extends T> partialKey) {
        return this.getFullKeysByPartialKey(Objects.requireNonNull(partialKey)).map(key -> new AbstractMap.SimpleImmutableEntry((Iterable)key, this.get(key)));
    }

    default public Stream<V> getValuesByPartialKey(Iterable<? extends T> partialKey, Iterable<Integer> positions) {
        return this.getFullKeysByPartialKey(partialKey, positions).map(key -> this.get(key));
    }

    default public Stream<Map.Entry<K, V>> getEntriesByPartialKey(Iterable<? extends T> partialKey, Iterable<Integer> positions) {
        return this.getFullKeysByPartialKey(partialKey, positions).map(key -> new AbstractMap.SimpleImmutableEntry((Iterable)key, this.get(key)));
    }

    default public Stream<K> getFullKeysByPartialKey(final Iterable<? extends T> partialKey, final Iterable<Integer> positions) {
        Stream<K> keyStream = this.getFullKeysByPartialKey(StreamSupport.stream(Objects.requireNonNull(partialKey).spliterator(), true).collect(Collectors.toSet()));
        class IterableMatcher {
            final Map<Integer, T> symbols = new HashMap();
            final Map<T, Integer> counters = new HashMap();
            final int totalCount;

            IterableMatcher() {
                Iterator it = positions.iterator();
                boolean morePositions = true;
                int totalCount = 0;
                for (Object el : partialKey) {
                    int position;
                    if (morePositions && (morePositions = it.hasNext()) && (position = ((Integer)it.next()).intValue()) >= 0) {
                        if (this.symbols.put(position, el) != null) {
                            throw new IllegalArgumentException(String.format("duplicate positive position %s", position));
                        }
                        ++totalCount;
                        continue;
                    }
                    ++totalCount;
                    this.counters.merge(el, 1, (oldValue, value) -> oldValue + 1);
                }
                this.totalCount = totalCount;
            }

            boolean matches(K fullKey) {
                Objects.requireNonNull(fullKey);
                HashMap counters = new HashMap(this.counters);
                int totalCount = this.totalCount;
                int i = -1;
                for (Object el : fullKey) {
                    Object fixedPositionSubKey;
                    if ((fixedPositionSubKey = this.symbols.get(++i)) == null) {
                        boolean[] found = new boolean[]{false};
                        counters.computeIfPresent(el, (subKey, count) -> {
                            found[0] = true;
                            return (count = Integer.valueOf(count - 1)) == 0 ? null : count;
                        });
                        if (!found[0] || --totalCount != 0) continue;
                        return true;
                    }
                    if (fixedPositionSubKey.equals(el)) {
                        if (--totalCount != 0) continue;
                        return true;
                    }
                    return false;
                }
                return totalCount == 0;
            }
        }
        IterableMatcher matcher = new IterableMatcher();
        return keyStream.filter(key -> matcher.matches(key));
    }
}

