/*
 * Decompiled with CFR 0.152.
 */
package com.github.protobufel.multikeymap;

import com.github.protobufel.multikeymap.MultiKeyMap;
import com.github.protobufel.multikeymap.MultiKeyMaps;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Collectors {
    private Collectors() {
    }

    public static <T> Optional<Set<T>> intersectSets(Iterable<? extends Set<T>> source, boolean parallel) {
        return Collectors.streamOf(Objects.requireNonNull(source), parallel).min(Comparator.comparingInt(set -> Objects.requireNonNull(set).size())).flatMap(smallestSet -> {
            Set result = Collectors.streamOf(source, parallel).collect(Collectors.setIntersecting(smallestSet, parallel));
            return result.isEmpty() ? Optional.empty() : Optional.of(result);
        });
    }

    static <T> Stream<T> streamOf(Iterable<T> source, boolean parallel) {
        if (source instanceof Collection) {
            Collection collection = (Collection)source;
            return (Stream)(parallel ? collection.parallelStream() : collection.stream()).unordered();
        }
        return (Stream)StreamSupport.stream(Objects.requireNonNull(source).spliterator(), parallel).unordered();
    }

    public static <T> Collector<Set<T>, Set<T>, Set<T>> setIntersecting(Set<T> smallestSet, boolean parallel) {
        return Collectors.setIntersecting(() -> smallestSet, parallel);
    }

    public static <T> Collector<Set<T>, Set<T>, Set<T>> setIntersecting(Supplier<Set<T>> smallestSetSupplier, boolean parallel) {
        return parallel ? new ConcurrentSetIntersecting(smallestSetSupplier) : new SequentialSetIntersecting(smallestSetSupplier);
    }

    public static <T, E, K extends Iterable<E>, V> Collector<T, ?, MultiKeyMap<E, K, V>> toMultiKeyMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return java.util.stream.Collectors.toMap(keyMapper, valueMapper, (k, v) -> {
            throw new IllegalStateException(String.format("duplicate key %s", k));
        }, MultiKeyMaps::newMultiKeyMap);
    }

    public static <T, E, K extends Iterable<E>, V> Collector<T, ?, MultiKeyMap<E, K, V>> toMultiKeyMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, BinaryOperator<V> mergeFunction) {
        return java.util.stream.Collectors.toMap(keyMapper, valueMapper, mergeFunction, MultiKeyMaps::newMultiKeyMap);
    }

    public static <T, E, K extends Iterable<E>, V, M extends MultiKeyMap<E, K, V>> Collector<T, ?, M> toMultiKeyMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, BinaryOperator<V> mergeFunction, Supplier<M> multiKeyMapSupplier) {
        return java.util.stream.Collectors.toMap(keyMapper, valueMapper, mergeFunction, multiKeyMapSupplier);
    }

    static final class SequentialSetIntersecting<K>
    implements Collector<Set<K>, Set<K>, Set<K>> {
        private final Supplier<Set<K>> smallestSetSupplier;

        SequentialSetIntersecting(Supplier<Set<K>> smallestSetSupplier) {
            this.smallestSetSupplier = Objects.requireNonNull(smallestSetSupplier);
        }

        @Override
        public Supplier<Set<K>> supplier() {
            return () -> new HashSet(this.smallestSetSupplier.get());
        }

        @Override
        public BiConsumer<Set<K>, Set<K>> accumulator() {
            return (set1, set2) -> {
                if (set2 != this.smallestSetSupplier.get() && !set1.isEmpty() && !set2.isEmpty()) {
                    set1.retainAll((Collection<?>)set2);
                }
            };
        }

        @Override
        public BinaryOperator<Set<K>> combiner() {
            return (set1, set2) -> set1.isEmpty() || set2.isEmpty() || set1.retainAll((Collection<?>)set2) && set1.isEmpty() ? Collections.emptySet() : set1;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH, Collector.Characteristics.UNORDERED));
        }

        @Override
        public Function<Set<K>, Set<K>> finisher() {
            return Function.identity();
        }
    }

    static final class ConcurrentSetIntersecting<K>
    implements Collector<Set<K>, Set<K>, Set<K>> {
        private final Supplier<Set<K>> smallestSetSupplier;

        ConcurrentSetIntersecting(Supplier<Set<K>> smallestSetSupplier) {
            this.smallestSetSupplier = Objects.requireNonNull(smallestSetSupplier);
        }

        @Override
        public Supplier<Set<K>> supplier() {
            return () -> {
                Set<K> smallestSet = this.smallestSetSupplier.get();
                ConcurrentHashMap.KeySetView<K, Boolean> newKeySet = ConcurrentHashMap.newKeySet(smallestSet.size());
                newKeySet.addAll((Collection<K>)smallestSet);
                return newKeySet;
            };
        }

        @Override
        public BiConsumer<Set<K>, Set<K>> accumulator() {
            return (set1, set2) -> {
                if (set2 != this.smallestSetSupplier.get() && !set1.isEmpty() && !set2.isEmpty()) {
                    set1.retainAll((Collection<?>)set2);
                }
            };
        }

        @Override
        public BinaryOperator<Set<K>> combiner() {
            return (set1, set2) -> set1.isEmpty() || set2.isEmpty() || set1.retainAll((Collection<?>)set2) && set1.isEmpty() ? Collections.emptySet() : set1;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.unmodifiableSet(EnumSet.allOf(Collector.Characteristics.class));
        }

        @Override
        public Function<Set<K>, Set<K>> finisher() {
            return Function.identity();
        }
    }
}

