/*
 * Decompiled with CFR 0.152.
 */
package com.github.protobufel.multikeymap;

import com.github.protobufel.multikeymap.Collectors;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

final class Matchers {
    private Matchers() {
    }

    public static <T> boolean matchesByPositions(Iterable<? extends Iterable<? extends T>> source, Iterable<? extends T> search, Iterable<Integer> positions) {
        Objects.requireNonNull(source);
        IterablePositionMatcher<T> matcher = new IterablePositionMatcher<T>(Objects.requireNonNull(search), Objects.requireNonNull(positions));
        for (Iterable<T> iterable : source) {
            if (matcher.matches(iterable)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean matchesByPositionalPattern(Iterable<? extends Iterable<? extends T>> source, Iterable<? extends T> search, Pattern pattern) {
        Objects.requireNonNull(source);
        IterablePatternMatcher<T> matcher = new IterablePatternMatcher<T>(Objects.requireNonNull(search), Objects.requireNonNull(pattern));
        for (Iterable<T> iterable : source) {
            if (matcher.matches(iterable)) continue;
            return false;
        }
        return true;
    }

    static class IterablePatternMatcher<T> {
        final Map<T, String> symbols;
        final Pattern pattern;

        IterablePatternMatcher(Iterable<? extends T> search, Pattern pattern) {
            Objects.requireNonNull(search);
            this.pattern = Objects.requireNonNull(pattern);
            this.symbols = new HashMap<T, String>();
            int i = 0;
            for (T el : search) {
                int n = i;
                i = (short)(i + 1);
                this.symbols.put(el, String.valueOf(n));
            }
        }

        boolean matches(Iterable<? extends T> source) {
            return this.matches(source, this.pattern);
        }

        boolean matches(Iterable<? extends T> source, Pattern pattern) {
            Objects.requireNonNull(pattern);
            String s = Collectors.streamOf(Objects.requireNonNull(source), false).map(x -> this.symbols.getOrDefault(x, "")).collect(java.util.stream.Collectors.joining(","));
            return pattern.matcher(s).matches();
        }
    }

    static class IterablePositionMatcher<T> {
        final Map<Integer, Set<T>> symbols = new HashMap<Integer, Set<T>>();
        final Map<T, Integer> counters = new HashMap<T, Integer>();
        final int totalCount;

        IterablePositionMatcher(Iterable<? extends T> search, Iterable<Integer> positions) {
            Iterator<Integer> it = positions.iterator();
            boolean morePositions = true;
            int[] totalCount = new int[]{0};
            for (T el : search) {
                int position;
                if (morePositions && (morePositions = it.hasNext()) && (position = it.next().intValue()) >= 0) {
                    this.symbols.computeIfAbsent(position, k -> {
                        totalCount[0] = totalCount[0] + 1;
                        return new HashSet();
                    }).add(el);
                    continue;
                }
                totalCount[0] = totalCount[0] + 1;
                this.counters.merge(el, 1, (oldValue, value) -> oldValue + 1);
            }
            this.totalCount = totalCount[0];
        }

        boolean matches(Iterable<? extends T> source) {
            Objects.requireNonNull(source);
            HashMap<T, Integer> counters = new HashMap<T, Integer>(this.counters);
            int totalCount = this.totalCount;
            int i = -1;
            for (T el : source) {
                Set<T> fixedPositionSet;
                if ((fixedPositionSet = this.symbols.get(++i)) == null) {
                    boolean[] found = new boolean[]{false};
                    counters.computeIfPresent(el, (subKey, count) -> {
                        found[0] = true;
                        return (count = Integer.valueOf(count - 1)) == 0 ? null : count;
                    });
                    if (!found[0] || --totalCount != 0) continue;
                    return true;
                }
                if (fixedPositionSet.contains(el)) {
                    if (--totalCount != 0) continue;
                    return true;
                }
                return false;
            }
            return totalCount == 0;
        }
    }
}

