/*
 * Decompiled with CFR 0.152.
 */
package com.github.protobufel.multikeymap;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

interface LiteSetMultimap<K, V> {
    public static <K, V> LiteSetMultimap<K, V> newInstance() {
        return LiteSetMultimap.newInstance(false);
    }

    public static <K, V> LiteSetMultimap<K, V> newInstance(boolean concurrent) {
        return concurrent ? new ConcurrentLiteSetMultimap() : new RegularLiteSetMultimap();
    }

    public void clear();

    public boolean remove(K var1, V var2);

    public int size();

    public boolean isEmpty();

    public Set<V> get(K var1);

    public boolean put(K var1, V var2);

    default public boolean isConcurrent() {
        return this.getClass().isAssignableFrom(ConcurrentLiteSetMultimap.class);
    }

    public static abstract class BaseLiteSetMultimap<K, V>
    implements LiteSetMultimap<K, V> {
        private final Map<K, Set<V>> map;

        public BaseLiteSetMultimap(Map<K, Set<V>> map) {
            this.map = map;
        }

        abstract Set<V> newSet();

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Set<V> get(Object key) {
            return this.map.get(key);
        }

        @Override
        public boolean put(K key, V value) {
            return this.map.computeIfAbsent(Objects.requireNonNull(key), k -> this.newSet()).add(Objects.requireNonNull(value));
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean remove(K key, V value) {
            boolean[] removed = new boolean[]{false};
            this.map.computeIfPresent(Objects.requireNonNull(key), (k, v) -> {
                removed[0] = v.remove(value);
                if (removed[0] && v.isEmpty()) {
                    return null;
                }
                return v;
            });
            return removed[0];
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map)) {
                return false;
            }
            return this.map.equals(o);
        }

        public int hashCode() {
            return this.map.hashCode();
        }
    }

    public static class RegularLiteSetMultimap<K, V>
    extends BaseLiteSetMultimap<K, V>
    implements Serializable {
        private static final long serialVersionUID = -1557045174464645635L;

        public RegularLiteSetMultimap() {
            super(new HashMap());
        }

        @Override
        protected Set<V> newSet() {
            return new HashSet();
        }
    }

    public static class ConcurrentLiteSetMultimap<K, V>
    extends BaseLiteSetMultimap<K, V>
    implements Serializable {
        private static final long serialVersionUID = -5018582265479564955L;

        public ConcurrentLiteSetMultimap() {
            super(new ConcurrentHashMap());
        }

        @Override
        protected Set<V> newSet() {
            return new ConcurrentHashMap().keySet(true);
        }
    }
}

