/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen;

import com.speedment.common.codegen.DependencyManager;
import com.speedment.common.codegen.Meta;
import com.speedment.common.codegen.RenderStack;
import com.speedment.common.codegen.Transform;
import com.speedment.common.codegen.TransformFactory;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

public interface Generator {
    public DependencyManager getDependencyMgr();

    public RenderStack getRenderStack();

    public <A, B> Stream<Meta<A, B>> metaOn(A var1, Class<B> var2);

    default public <A, B> Stream<Meta<A, B>> metaOn(A from, Class<B> to, Class<? extends Transform<A, B>> transform) {
        return this.metaOn(from, to).filter(meta -> transform.equals(meta.getTransform().getClass()));
    }

    default public <M> Stream<Meta<M, String>> metaOn(M model) {
        return this.metaOn(model, String.class);
    }

    default public <A> Stream<Meta<A, String>> metaOn(Collection<A> models) {
        return models.stream().map(this::metaOn).flatMap(m -> m);
    }

    default public <A, B> Stream<Meta<A, B>> metaOn(Collection<A> models, Class<B> to) {
        return models.stream().map(model -> this.metaOn(model, to)).flatMap(m -> m);
    }

    default public <A, B> Stream<Meta<A, B>> metaOn(Collection<A> models, Class<B> to, Class<? extends Transform<A, B>> transform) {
        return this.metaOn(models, to).filter(meta -> meta.getTransform().is(transform));
    }

    default public Optional<String> on(Object model) {
        if (model instanceof Optional) {
            Optional result = (Optional)model;
            if (result.isPresent()) {
                model = result.get();
            } else {
                return Optional.empty();
            }
        }
        return this.metaOn(model).map(Meta::getResult).findAny();
    }

    default public <M> Stream<String> onEach(Collection<M> models) {
        return this.metaOn(models).map(Meta::getResult);
    }

    public <A, B> Optional<Meta<A, B>> transform(Transform<A, B> var1, A var2, TransformFactory var3);
}

