/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.constant;

import com.speedment.common.codegen.constant.SimpleParameterizedType;
import com.speedment.common.codegen.constant.SimpleType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class DefaultType {
    public static Type WILDCARD = SimpleType.create("?");
    private static final Map<String, Class<?>> WRAPPERS;

    public static Type classOf(Type innerType) {
        return SimpleParameterizedType.create(Class.class, new Type[]{innerType});
    }

    public static Type list(Type innerType) {
        return SimpleParameterizedType.create(List.class, new Type[]{innerType});
    }

    public static Type set(Type innerType) {
        return SimpleParameterizedType.create(Set.class, new Type[]{innerType});
    }

    public static Type map(Type innerTypeA, Type innerTypeB) {
        return SimpleParameterizedType.create(Map.class, new Type[]{innerTypeA, innerTypeB});
    }

    public static Type queue(Type innerType) {
        return SimpleParameterizedType.create(Queue.class, new Type[]{innerType});
    }

    public static Type stack(Type innerType) {
        return SimpleParameterizedType.create(Stack.class, new Type[]{innerType});
    }

    public static Type optional(Type innerType) {
        return SimpleParameterizedType.create(Optional.class, new Type[]{innerType});
    }

    public static Type entry(Type innerTypeA, Type innerTypeB) {
        return SimpleParameterizedType.create(Map.Entry.class, new Type[]{innerTypeA, innerTypeB});
    }

    public static Type function(Type innerTypeA, Type innerTypeB) {
        return SimpleParameterizedType.create(Function.class, new Type[]{innerTypeA, innerTypeB});
    }

    public static Type predicate(Type innerType) {
        return SimpleParameterizedType.create(Predicate.class, new Type[]{innerType});
    }

    public static Type consumer(Type innerType) {
        return SimpleParameterizedType.create(Consumer.class, new Type[]{innerType});
    }

    public static Type supplier(Type innerType) {
        return SimpleParameterizedType.create(Supplier.class, new Type[]{innerType});
    }

    public static Type stream(Type innerType) {
        return SimpleParameterizedType.create(Stream.class, new Type[]{innerType});
    }

    public static boolean isPrimitive(Type type) {
        return WRAPPERS.keySet().contains(type.getTypeName());
    }

    public static Class<?> wrapperFor(Type primitiveType) {
        return Objects.requireNonNull(WRAPPERS.get(primitiveType.getTypeName()), "No wrapper found for type '" + primitiveType.getTypeName() + "'.");
    }

    private DefaultType() {
        throw new RuntimeException("This class should never be instantiated.");
    }

    static {
        HashMap<String, Class> temp = new HashMap<String, Class>();
        temp.put("byte", Byte.class);
        temp.put("short", Short.class);
        temp.put("int", Integer.class);
        temp.put("long", Long.class);
        temp.put("float", Float.class);
        temp.put("double", Double.class);
        temp.put("boolean", Boolean.class);
        temp.put("char", Character.class);
        WRAPPERS = Collections.unmodifiableMap(temp);
    }
}

