/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.constant;

import com.speedment.common.codegen.model.ClassOrInterface;
import com.speedment.common.codegen.model.File;
import com.speedment.common.codegen.model.trait.HasClasses;
import com.speedment.common.codegen.util.Formatting;
import java.util.Optional;

final class SimpleTypeUtil {
    public static String nameOf(File file, ClassOrInterface<?> clazz) {
        String name = (String)Formatting.fileToClassName(file.getName()).flatMap(Formatting::packageName).orElseThrow(() -> new RuntimeException("File did not have appropriate name.")) + "." + SimpleTypeUtil.pathTo(file, clazz.getName());
        return name;
    }

    private static String pathTo(HasClasses<?> parent, String needle) {
        return SimpleTypeUtil.pathTo(parent, "", needle).orElseThrow(() -> new RuntimeException("No class '" + needle + "' found in parent '" + parent + "'."));
    }

    private static Optional<String> pathTo(HasClasses<?> parent, String path, String needle) {
        for (ClassOrInterface<?> child : parent.getClasses()) {
            String newPath;
            String childName = child.getName();
            String string = newPath = path.isEmpty() ? "" : path + "." + childName;
            if (childName.equals(needle)) {
                return Optional.of(newPath);
            }
            Optional<String> recursion = SimpleTypeUtil.pathTo(child, newPath, needle);
            if (!recursion.isPresent()) continue;
            return recursion;
        }
        return Optional.empty();
    }

    private SimpleTypeUtil() {
    }
}

