/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.controller;

import com.speedment.common.codegen.model.ClassOrInterface;
import com.speedment.common.codegen.model.Constructor;
import com.speedment.common.codegen.model.Initializer;
import com.speedment.common.codegen.model.Method;
import com.speedment.common.codegen.model.Value;
import com.speedment.common.codegen.model.trait.HasClasses;
import com.speedment.common.codegen.model.trait.HasCode;
import com.speedment.common.codegen.model.trait.HasConstructors;
import com.speedment.common.codegen.model.trait.HasFields;
import com.speedment.common.codegen.model.trait.HasInitializers;
import com.speedment.common.codegen.model.trait.HasJavadoc;
import com.speedment.common.codegen.model.trait.HasMethods;
import com.speedment.common.codegen.model.value.ReferenceValue;
import com.speedment.common.codegen.util.Formatting;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class AlignTabs<T>
implements Consumer<T> {
    @Override
    public void accept(T model) {
        Object casted;
        if (model instanceof HasCode) {
            casted = (HasCode)model;
            Formatting.alignTabs(casted.getCode());
        }
        if (model instanceof HasClasses) {
            casted = (HasClasses)model;
            casted.getClasses().forEach(c -> {
                ClassOrInterface cfr_ignored_0 = (ClassOrInterface)c.call(new AlignTabs());
            });
        }
        if (model instanceof HasMethods) {
            casted = (HasMethods)model;
            casted.getMethods().forEach(c -> {
                Method cfr_ignored_0 = (Method)c.call(new AlignTabs());
            });
        }
        if (model instanceof HasConstructors) {
            casted = (HasConstructors)model;
            casted.getConstructors().forEach(c -> {
                Constructor cfr_ignored_0 = (Constructor)c.call(new AlignTabs());
            });
        }
        if (model instanceof HasInitializers) {
            casted = (HasInitializers)model;
            casted.getInitializers().forEach(c -> {
                Initializer cfr_ignored_0 = (Initializer)c.call(new AlignTabs());
            });
        }
        if (model instanceof HasFields) {
            casted = (HasFields)model;
            AlignTabs.alignTabs(casted.getFields(), field -> field.getValue().filter(ReferenceValue.class::isInstance).map(ReferenceValue.class::cast).map(Value::getValue).orElse(null), (field, value) -> ((ReferenceValue)field.getValue().get()).setValue(value));
        }
        if (model instanceof HasJavadoc) {
            casted = (HasJavadoc)model;
            casted.getJavadoc().ifPresent(javadoc -> {
                List<String> rows = Stream.of(javadoc.getText().split(Formatting.nl())).collect(Collectors.toList());
                Formatting.alignTabs(rows);
                javadoc.setText(rows.stream().collect(Collectors.joining(Formatting.nl())));
            });
        }
    }

    private static <T> void alignTabs(List<T> models, Function<T, String> getRow, BiConsumer<T, String> setRow) {
        AtomicInteger maxIndex = new AtomicInteger(-1);
        block0: while (true) {
            maxIndex.set(-1);
            models.stream().forEachOrdered(model -> {
                int index;
                String row = (String)getRow.apply(model);
                if (row != null && (index = row.indexOf(9)) > maxIndex.get()) {
                    maxIndex.set(index);
                }
            });
            if (maxIndex.get() <= -1) break;
            int i = 0;
            while (true) {
                int index;
                if (i >= models.size()) continue block0;
                T model2 = models.get(i);
                String row = getRow.apply(model2);
                if (row != null && (index = row.indexOf(9)) > -1) {
                    setRow.accept(model2, row.replaceFirst("\t", Formatting.repeat(" ", maxIndex.get() - index)));
                }
                ++i;
            }
            break;
        }
    }
}

