/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.controller;

import com.speedment.common.codegen.DependencyManager;
import com.speedment.common.codegen.internal.model.ImportImpl;
import com.speedment.common.codegen.model.File;
import com.speedment.common.codegen.model.trait.HasAnnotationUsage;
import com.speedment.common.codegen.model.trait.HasClasses;
import com.speedment.common.codegen.model.trait.HasConstructors;
import com.speedment.common.codegen.model.trait.HasFields;
import com.speedment.common.codegen.model.trait.HasGenerics;
import com.speedment.common.codegen.model.trait.HasImplements;
import com.speedment.common.codegen.model.trait.HasMethods;
import com.speedment.common.codegen.model.trait.HasSupertype;
import com.speedment.common.codegen.model.trait.HasThrows;
import com.speedment.common.codegen.model.trait.HasType;
import com.speedment.common.codegen.util.Formatting;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public final class AutoImports
implements Consumer<File> {
    private final DependencyManager mgr;

    public AutoImports(DependencyManager mgr) {
        this.mgr = Objects.requireNonNull(mgr);
    }

    @Override
    public void accept(File file) {
        this.findTypesIn(Objects.requireNonNull(file)).forEach((s, t) -> {
            File cfr_ignored_0 = (File)file.add(new ImportImpl((Type)t));
        });
    }

    private Map<String, Type> findTypesIn(Object model) {
        HashMap<String, Type> map = new HashMap<String, Type>();
        this.findTypesIn(Objects.requireNonNull(model), map);
        return map;
    }

    private void findTypesIn(Object model, Map<String, Type> types) {
        Objects.requireNonNull(model);
        Objects.requireNonNull(types);
        if (HasSupertype.class.isInstance(model)) {
            ((HasSupertype)model).getSupertype().ifPresent(t -> this.addType((Type)t, types));
        }
        if (HasAnnotationUsage.class.isInstance(model)) {
            ((HasAnnotationUsage)model).getAnnotations().forEach(a -> this.addType(a.getType(), types));
        }
        if (HasClasses.class.isInstance(model)) {
            ((HasClasses)model).getClasses().forEach(c -> this.findTypesIn(c, types));
        }
        if (HasConstructors.class.isInstance(model)) {
            ((HasConstructors)model).getConstructors().forEach(c -> this.findTypesIn(c, types));
        }
        if (HasFields.class.isInstance(model)) {
            ((HasFields)model).getFields().forEach(f -> {
                this.addType(f.getType(), types);
                this.findTypesIn(f, types);
            });
        }
        if (HasGenerics.class.isInstance(model)) {
            ((HasGenerics)model).getGenerics().forEach(g -> g.getUpperBounds().forEach(ub -> this.addType((Type)ub, types)));
        }
        if (HasImplements.class.isInstance(model)) {
            ((HasImplements)model).getInterfaces().forEach(i -> this.addType((Type)i, types));
        }
        if (HasMethods.class.isInstance(model)) {
            ((HasMethods)model).getMethods().forEach(m -> {
                this.addType(m.getType(), types);
                this.findTypesIn(m, types);
            });
        }
        if (HasThrows.class.isInstance(model)) {
            ((HasThrows)model).getExceptions().forEach(e -> this.addType((Type)e, types));
        }
        if (HasType.class.isInstance(model)) {
            this.addType(((HasType)model).getType(), types);
        }
    }

    private void addType(Type type, Map<String, Type> types) {
        ParameterizedType generic;
        Objects.requireNonNull(type);
        Objects.requireNonNull(types);
        String name = type.getTypeName();
        if (name.contains("<")) {
            name = name.substring(0, name.indexOf("<"));
        }
        if (name.contains("[")) {
            name = name.substring(0, name.indexOf("["));
        }
        if (name.contains(".") && !this.mgr.isIgnored(name)) {
            String shortName = Formatting.shortName(name);
            if (types.keySet().stream().map(Formatting::shortName).noneMatch(shortName::equals)) {
                types.put(name, type);
            }
        }
        if (type instanceof ParameterizedType && (generic = (ParameterizedType)type).getActualTypeArguments().length > 0) {
            this.findTypesIn(type, types);
            for (Type genType : generic.getActualTypeArguments()) {
                this.addType(genType, types);
            }
        }
    }
}

