/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.controller;

import com.speedment.common.codegen.constant.SimpleParameterizedType;
import com.speedment.common.codegen.constant.SimpleType;
import com.speedment.common.codegen.model.Class;
import com.speedment.common.codegen.model.Field;
import com.speedment.common.codegen.model.File;
import com.speedment.common.codegen.model.Generic;
import com.speedment.common.codegen.model.Javadoc;
import com.speedment.common.codegen.model.JavadocTag;
import com.speedment.common.codegen.model.Method;
import com.speedment.common.codegen.util.Formatting;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

public final class SetGetAdd
implements Consumer<File> {
    private final BiPredicate<Field, Method> onlyInclude;

    public SetGetAdd() {
        this.onlyInclude = (f, m) -> true;
    }

    public SetGetAdd(BiPredicate<Field, Method> onlyInclude) {
        this.onlyInclude = Objects.requireNonNull(onlyInclude);
    }

    @Override
    public void accept(File file) {
        file.getClasses().stream().filter(Class.class::isInstance).map(Class.class::cast).forEach(c -> this.accept(file, (Class)c));
    }

    private void accept(File file, Class model) {
        Type self = model.getGenerics().isEmpty() ? SimpleType.create(file, model) : SimpleParameterizedType.create(file, model, (Type[])model.getGenerics().stream().map(Generic::asType).toArray(Type[]::new));
        Objects.requireNonNull(model).getFields().forEach(f -> {
            f.private_();
            if (this.isCollection(f.getType())) {
                f.final_();
                ParameterizedType paramType = (ParameterizedType)f.getType();
                Field param = Field.of(this.singular(f.getName()), paramType.getActualTypeArguments()[0]);
                Method add = (Method)((Method)((Method)((Method)((Method)Method.of("add", self).set((Javadoc)((Javadoc)Javadoc.of().setText("Adds the specified " + Formatting.lcfirst(Formatting.shortName(param.getType().getTypeName())) + " to this " + Formatting.shortName(model.getName()) + ".").add(JavadocTag.of("param", param.getName(), "the new value"))).add(JavadocTag.of("return", "a reference to this object")))).public_()).add(param)).add("this." + f.getName() + ".add(" + param.getName() + ");")).add("return this;");
                if (this.onlyInclude.test((Field)f, add)) {
                    model.add(add);
                }
            } else {
                Method set = (Method)((Method)Method.of("set" + Formatting.ucfirst(f.getName()), self).set((Javadoc)((Javadoc)Javadoc.of().setText("Sets the " + f.getName() + " of this " + Formatting.shortName(model.getName()) + ".").add(JavadocTag.of("param", f.getName(), "the new value"))).add(JavadocTag.of("return", "a reference to this object")))).public_();
                if (this.isOptional(f.getType())) {
                    ParameterizedType paramType = (ParameterizedType)f.getType();
                    ((Method)((Method)set.add(Field.of(f.getName(), paramType.getActualTypeArguments()[0]))).add("this." + f.getName() + " = Optional.of(" + f.getName() + ");")).add("return this;");
                } else {
                    ((Method)((Method)set.add(Field.of(f.getName(), f.getType()))).add("this." + f.getName() + " = " + f.getName() + ";")).add("return this;");
                }
                if (this.onlyInclude.test((Field)f, set)) {
                    model.add(set);
                }
            }
            Method get = (Method)((Method)((Method)Method.of("get" + Formatting.ucfirst(f.getName()), f.getType()).set((Javadoc)Javadoc.of().setText("Gets the " + f.getName() + " of this " + Formatting.shortName(model.getName()) + ".").add(JavadocTag.of("return", "the " + f.getName())))).public_()).add("return this." + f.getName() + ";");
            if (this.onlyInclude.test((Field)f, get)) {
                model.add(get);
            }
        });
        model.getClasses().stream().filter(Class.class::isInstance).map(Class.class::cast).forEach(c -> this.accept(file, (Class)c));
    }

    private boolean isCollection(Type type) {
        if (type instanceof java.lang.Class) {
            java.lang.Class clazz = (java.lang.Class)type;
            return Collection.class.isAssignableFrom(clazz);
        }
        return false;
    }

    private boolean isOptional(Type type) {
        return type.getTypeName().startsWith("java.lang.Optional");
    }

    private String singular(String word) {
        if (Objects.requireNonNull(word).endsWith("ies")) {
            return word.substring(0, word.length() - 3) + "y";
        }
        if (word.endsWith("s")) {
            return word.substring(0, word.length() - 1);
        }
        return word;
    }
}

