/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal;

import com.speedment.common.codegen.DependencyManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultDependencyManager
implements DependencyManager {
    private final Set<String> dependencies = new HashSet<String>();
    private final Set<Pattern> ignorePatterns;
    private String currentPackage;

    public DefaultDependencyManager() {
        this.ignorePatterns = Collections.emptySet();
    }

    public DefaultDependencyManager(Pattern ... ignoredPatterns) {
        this.ignorePatterns = Stream.of(ignoredPatterns).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    @Override
    public boolean load(String fullname) {
        return this.dependencies.add(Objects.requireNonNull(fullname));
    }

    @Override
    public boolean isLoaded(String fullname) {
        return this.dependencies.contains(Objects.requireNonNull(fullname));
    }

    @Override
    public void clearDependencies() {
        this.dependencies.clear();
    }

    @Override
    public boolean isIgnored(String fullname) {
        return this.ignorePatterns.stream().map(Pattern::asPredicate).anyMatch(p -> p.test(Objects.requireNonNull(fullname)));
    }

    @Override
    public boolean setCurrentPackage(String pack) {
        if (this.currentPackage == null) {
            this.currentPackage = Objects.requireNonNull(pack);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetCurrentPackage(String pack) {
        if (this.currentPackage != null && this.currentPackage.equals(Objects.requireNonNull(pack))) {
            this.currentPackage = null;
            return true;
        }
        return false;
    }

    @Override
    public Optional<String> getCurrentPackage() {
        return Optional.ofNullable(this.currentPackage);
    }
}

