/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal;

import com.speedment.common.codegen.Transform;
import com.speedment.common.codegen.TransformFactory;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class DefaultTransformFactory
implements TransformFactory {
    private final Map<Class<?>, Set<Map.Entry<Class<?>, Class<? extends Transform<?, ?>>>>> transforms;
    private final String name;

    public DefaultTransformFactory(String name) {
        this.name = Objects.requireNonNull(name);
        this.transforms = new ConcurrentHashMap();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <A, B, T extends Transform<A, B>> TransformFactory install(Class<A> from, Class<B> to, Class<T> transform) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        Objects.requireNonNull(transform);
        this.transforms.computeIfAbsent(from, f -> new HashSet()).add(new AbstractMap.SimpleEntry<Class<B>, Class<T>>(to, transform));
        return this;
    }

    @Override
    public <A, T extends Transform<A, ?>> Set<Map.Entry<Class<?>, T>> allFrom(Class<A> model) {
        Objects.requireNonNull(model);
        return this.transforms.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(model)).flatMap(e -> ((Set)e.getValue()).stream()).map(e -> DefaultTransformFactory.toEntry((Class)e.getKey(), (Transform)TransformFactory.create((Class)e.getValue()))).collect(Collectors.toSet());
    }

    private static <A, T extends Transform<A, ?>> Map.Entry<Class<?>, T> toEntry(Class<?> key, T value) {
        return new AbstractMap.SimpleEntry(key, value);
    }
}

