/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.java.view;

import com.speedment.common.codegen.Generator;
import com.speedment.common.codegen.Transform;
import com.speedment.common.codegen.internal.util.CollectorUtil;
import com.speedment.common.codegen.internal.util.NullUtil;
import com.speedment.common.codegen.model.Constructor;
import com.speedment.common.codegen.model.trait.HasName;
import com.speedment.common.codegen.util.Formatting;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ConstructorView
implements Transform<Constructor, String> {
    @Override
    public Optional<String> transform(Generator gen, Constructor model) {
        NullUtil.requireNonNulls(gen, model);
        return Optional.of(Formatting.ifelse(gen.on(model.getJavadoc()), s -> s + Formatting.nl(), "") + gen.onEach(model.getModifiers()).collect(CollectorUtil.joinIfNotEmpty(" ", "", " ")) + ConstructorView.renderName(gen, model).orElseThrow(() -> new UnsupportedOperationException("Could not find a nameable parent of constructor.")) + gen.onEach(model.getFields()).collect(Collectors.joining(this.fieldSeparator(model), model.getFields().size() > 3 ? "(" + Formatting.nl() : "(", ")")) + " " + gen.onEach(model.getExceptions()).collect(CollectorUtil.joinIfNotEmpty(", ", "throws ", " ")) + Formatting.block(model.getCode().stream().collect(Collectors.joining(Formatting.nl()))));
    }

    private static Optional<String> renderName(Generator gen, Constructor model) {
        NullUtil.requireNonNulls(gen, model);
        return gen.getRenderStack().fromTop(HasName.class).filter(n -> model != n).map(HasName::getName).map(Formatting::shortName).findFirst();
    }

    private String fieldSeparator(Constructor model) {
        if (model.getFields().size() > 3) {
            return "," + Formatting.nl() + Formatting.tab() + Formatting.tab();
        }
        return ", ";
    }
}

