/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.java.view;

import com.speedment.common.codegen.DependencyManager;
import com.speedment.common.codegen.Generator;
import com.speedment.common.codegen.Transform;
import com.speedment.common.codegen.internal.java.view.trait.HasClassesView;
import com.speedment.common.codegen.internal.java.view.trait.HasImportsView;
import com.speedment.common.codegen.internal.java.view.trait.HasJavadocView;
import com.speedment.common.codegen.internal.util.NullUtil;
import com.speedment.common.codegen.model.File;
import com.speedment.common.codegen.util.Formatting;
import java.util.Optional;

public final class FileView
implements Transform<File, String>,
HasImportsView<File>,
HasJavadocView<File>,
HasClassesView<File> {
    @Override
    public Optional<String> transform(Generator gen, File model) {
        NullUtil.requireNonNulls(gen, model);
        DependencyManager mgr = gen.getDependencyMgr();
        mgr.clearDependencies();
        String pack = Formatting.fileToClassName(model.getName()).flatMap(Formatting::packageName).orElse("");
        mgr.setCurrentPackage(pack);
        Optional<String> view = Optional.of(this.renderJavadoc(gen, model) + this.renderPackage(model) + this.renderImports(gen, model) + this.renderClasses(gen, model));
        mgr.unsetCurrentPackage(pack);
        return view;
    }

    private String renderPackage(File file) {
        Optional<String> pack;
        Optional<String> name = Formatting.fileToClassName(file.getName());
        if (name.isPresent() && (pack = Formatting.packageName(name.get())).isPresent()) {
            return "package " + pack.get() + ";" + Formatting.dnl();
        }
        return "";
    }
}

