/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.java.view;

import com.speedment.common.codegen.Generator;
import com.speedment.common.codegen.Transform;
import com.speedment.common.codegen.internal.java.view.trait.HasJavadocTagsView;
import com.speedment.common.codegen.internal.util.NullUtil;
import com.speedment.common.codegen.model.Javadoc;
import com.speedment.common.codegen.model.JavadocTag;
import com.speedment.common.codegen.model.trait.HasJavadoc;
import com.speedment.common.codegen.util.Formatting;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JavadocView
implements Transform<Javadoc, String>,
HasJavadocTagsView<Javadoc> {
    private static final int BLOCK_WIDTH = 80;
    private static final String JAVADOC_DELIMITER = Formatting.nl() + " * ";
    private static final String JAVADOC_PREFIX = "/**" + Formatting.nl() + " * ";
    private static final String JAVADOC_SUFFIX = Formatting.nl() + " */";

    @Override
    public Optional<String> transform(Generator gen, Javadoc model) {
        NullUtil.requireNonNulls(gen, model);
        int blockWidth = 77 - JavadocView.currentTabLevel(gen);
        String formattedText = JavadocView.formatText(model.getText(), 0, blockWidth).toString();
        Map tagGroups = model.getTags().stream().collect(Collectors.groupingBy(JavadocView::groupOf, TreeMap::new, Collectors.toList()));
        String tagSection = tagGroups.values().stream().map(tags -> {
            ArrayList rowBuilders = new ArrayList(tags.size());
            tags.forEach(tag -> {
                StringBuilder row = new StringBuilder("@").append(tag.getName());
                if (tag.getText().isPresent()) {
                    row.append(tag.getValue().map(v -> " " + v).orElse(""));
                }
                rowBuilders.add(row);
            });
            int indentTo = rowBuilders.stream().mapToInt(sb -> sb.length()).map(i -> i + 1).max().orElse(0);
            rowBuilders.forEach(row -> {
                int padding = indentTo - row.length();
                if (padding > 0) {
                    row.append(Formatting.repeat(" ", padding));
                }
            });
            for (int i2 = 0; i2 < rowBuilders.size(); ++i2) {
                JavadocTag tag2 = (JavadocTag)tags.get(i2);
                StringBuilder row2 = (StringBuilder)rowBuilders.get(i2);
                String content = tag2.getText().isPresent() ? tag2.getText().orElse("") : Stream.of(tag2.getValue().orElse(null), tag2.getText().orElse(null)).filter(s -> s != null).collect(Collectors.joining(" "));
                row2.append((CharSequence)JavadocView.formatText(content, indentTo, blockWidth));
            }
            return rowBuilders.stream().map(StringBuilder::toString).collect(Collectors.joining(Formatting.nl()));
        }).collect(Collectors.joining(Formatting.dnl()));
        return Optional.of(JAVADOC_PREFIX + Stream.of(formattedText, tagSection).filter(s -> s != null).filter(s -> !s.isEmpty()).collect(Collectors.joining(Formatting.dnl())).replace(Formatting.nl(), JAVADOC_DELIMITER) + JAVADOC_SUFFIX);
    }

    private static StringBuilder formatText(String text, int indentTo, int blockWidth) {
        StringBuilder row = new StringBuilder();
        AtomicInteger col = new AtomicInteger(indentTo);
        Stream.of(text.split(" ")).map(s -> s.replace("\t", Formatting.tab())).forEachOrdered(str -> {
            String[] words = str.split(Formatting.nl());
            for (int i = 0; i < words.length; ++i) {
                int extraSpace;
                String word = words[i];
                if (i > 0) {
                    row.append(Formatting.nl()).append(Formatting.repeat(" ", indentTo));
                    col.set(indentTo);
                }
                int n = extraSpace = col.get() > indentTo ? 1 : 0;
                if (col.get() + word.length() + extraSpace > blockWidth) {
                    row.append(Formatting.nl()).append(Formatting.repeat(" ", indentTo));
                    col.set(indentTo);
                }
                if (col.get() > indentTo) {
                    row.append(" ");
                    col.incrementAndGet();
                }
                row.append(word);
                col.addAndGet(word.length());
            }
        });
        return row;
    }

    private static int currentTabLevel(Generator gen) {
        int level = (int)gen.getRenderStack().fromTop(HasJavadoc.class).distinct().count();
        if (level <= 2) {
            return 0;
        }
        return (level - 2) * Formatting.tab().length();
    }

    private static String groupOf(JavadocTag tag) {
        switch (tag.getName()) {
            case "param": 
            case "return": {
                return "group_0";
            }
            case "throws": {
                return "group_1";
            }
            case "author": 
            case "deprecated": 
            case "since": 
            case "version": {
                return "group_2";
            }
            case "see": {
                return "group_3";
            }
        }
        return "group_4";
    }
}

