/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.model;

import com.speedment.common.codegen.internal.model.AnnotationUsageImpl;
import com.speedment.common.codegen.internal.util.Copier;
import com.speedment.common.codegen.model.AnnotationUsage;
import com.speedment.common.codegen.model.Value;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

abstract class AnnotationUsageBase
implements AnnotationUsage {
    private Type type;
    private Value<?> value;
    private final List<Map.Entry<String, Value<?>>> values;

    AnnotationUsageBase(Type type) {
        this.type = type;
        this.value = null;
        this.values = new ArrayList();
    }

    AnnotationUsageBase(AnnotationUsage prototype) {
        this.type = prototype.getType();
        this.value = prototype.getValue().map(Copier::copy).orElse(null);
        this.values = Copier.copy(prototype.getValues(), e -> new AbstractMap.SimpleEntry(e.getKey(), ((Value)e.getValue()).copy()));
    }

    @Override
    public AnnotationUsage set(Value<?> val) {
        this.value = val;
        return this;
    }

    @Override
    public AnnotationUsage put(String key, Value<?> val) {
        this.values.add(new AbstractMap.SimpleEntry(key, val));
        return this;
    }

    @Override
    public Optional<Value<?>> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public List<Map.Entry<String, Value<?>>> getValues() {
        return this.values;
    }

    @Override
    public AnnotationUsage set(Type type) {
        this.type = type;
        return this;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public AnnotationUsageImpl copy() {
        return new AnnotationUsageImpl(this);
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.type);
        hash = 67 * hash + Objects.hashCode(this.value);
        hash = 67 * hash + Objects.hashCode(this.values);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationUsageBase other = (AnnotationUsageBase)obj;
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        return Objects.equals(this.values, other.values);
    }
}

