/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.model;

import com.speedment.common.codegen.internal.model.ClassOrInterfaceImpl;
import com.speedment.common.codegen.internal.util.Copier;
import com.speedment.common.codegen.model.Class;
import com.speedment.common.codegen.model.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ClassImpl
extends ClassOrInterfaceImpl<Class>
implements Class {
    private Type superType;
    private final List<Constructor> constructors;

    public ClassImpl(String name) {
        super(name);
        this.superType = null;
        this.constructors = new ArrayList<Constructor>();
    }

    protected ClassImpl(Class prototype) {
        super(prototype);
        this.superType = prototype.getSupertype().orElse(null);
        this.constructors = Copier.copy(prototype.getConstructors());
    }

    @Override
    public Class setSupertype(Type superType) {
        this.superType = superType;
        return this;
    }

    @Override
    public Optional<Type> getSupertype() {
        return Optional.ofNullable(this.superType);
    }

    @Override
    public List<Constructor> getConstructors() {
        return this.constructors;
    }

    @Override
    public ClassImpl copy() {
        return new ClassImpl(this);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 11 * hash + Objects.hashCode(this.superType);
        hash = 11 * hash + Objects.hashCode(this.constructors);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassImpl other = (ClassImpl)obj;
        if (!Objects.equals(this.superType, other.superType)) {
            return false;
        }
        return Objects.equals(this.constructors, other.constructors);
    }
}

