/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.model;

import com.speedment.common.codegen.internal.util.Copier;
import com.speedment.common.codegen.model.AnnotationUsage;
import com.speedment.common.codegen.model.ClassOrInterface;
import com.speedment.common.codegen.model.Field;
import com.speedment.common.codegen.model.Generic;
import com.speedment.common.codegen.model.Initializer;
import com.speedment.common.codegen.model.Javadoc;
import com.speedment.common.codegen.model.Method;
import com.speedment.common.codegen.model.modifier.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class ClassOrInterfaceImpl<T extends ClassOrInterface<T>>
implements ClassOrInterface<T> {
    private String name;
    private Javadoc javadoc;
    private final List<AnnotationUsage> annotations;
    private final List<Generic> generics;
    private final List<Type> interfaces;
    private final List<Field> fields;
    private final List<Method> methods;
    private final List<Initializer> initalizers;
    private final List<ClassOrInterface<?>> classes;
    private final Set<Modifier> modifiers;

    ClassOrInterfaceImpl(String name) {
        this.name = Objects.requireNonNull(name);
        this.javadoc = null;
        this.annotations = new ArrayList<AnnotationUsage>();
        this.generics = new ArrayList<Generic>();
        this.interfaces = new ArrayList<Type>();
        this.fields = new ArrayList<Field>();
        this.methods = new ArrayList<Method>();
        this.initalizers = new ArrayList<Initializer>();
        this.classes = new ArrayList();
        this.modifiers = EnumSet.noneOf(Modifier.class);
    }

    ClassOrInterfaceImpl(ClassOrInterface<T> prototype) {
        this.name = Objects.requireNonNull(prototype).getName();
        this.javadoc = prototype.getJavadoc().map(Copier::copy).orElse(null);
        this.annotations = Copier.copy(prototype.getAnnotations());
        this.generics = Copier.copy(prototype.getGenerics());
        this.interfaces = new ArrayList<Type>(prototype.getInterfaces());
        this.fields = Copier.copy(prototype.getFields());
        this.methods = Copier.copy(prototype.getMethods());
        this.initalizers = Copier.copy(prototype.getInitializers());
        this.classes = Copier.copy(prototype.getClasses(), c -> (ClassOrInterface)c.copy());
        this.modifiers = Copier.copy(prototype.getModifiers(), c -> c.copy(), EnumSet.noneOf(Modifier.class));
    }

    @Override
    public T setName(String name) {
        this.name = Objects.requireNonNull(name);
        return (T)this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T set(Javadoc doc) {
        this.javadoc = doc;
        return (T)this;
    }

    @Override
    public Optional<Javadoc> getJavadoc() {
        return Optional.ofNullable(this.javadoc);
    }

    @Override
    public List<Method> getMethods() {
        return this.methods;
    }

    @Override
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public List<Type> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public List<Generic> getGenerics() {
        return this.generics;
    }

    @Override
    public List<AnnotationUsage> getAnnotations() {
        return this.annotations;
    }

    @Override
    public List<ClassOrInterface<?>> getClasses() {
        return this.classes;
    }

    @Override
    public List<Initializer> getInitializers() {
        return this.initalizers;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.name);
        hash = 37 * hash + Objects.hashCode(this.javadoc);
        hash = 37 * hash + Objects.hashCode(this.annotations);
        hash = 37 * hash + Objects.hashCode(this.generics);
        hash = 37 * hash + Objects.hashCode(this.interfaces);
        hash = 37 * hash + Objects.hashCode(this.fields);
        hash = 37 * hash + Objects.hashCode(this.methods);
        hash = 37 * hash + Objects.hashCode(this.initalizers);
        hash = 37 * hash + Objects.hashCode(this.classes);
        hash = 37 * hash + Objects.hashCode(this.modifiers);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassOrInterfaceImpl other = (ClassOrInterfaceImpl)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.javadoc, other.javadoc)) {
            return false;
        }
        if (!Objects.equals(this.annotations, other.annotations)) {
            return false;
        }
        if (!Objects.equals(this.generics, other.generics)) {
            return false;
        }
        if (!Objects.equals(this.interfaces, other.interfaces)) {
            return false;
        }
        if (!Objects.equals(this.fields, other.fields)) {
            return false;
        }
        if (!Objects.equals(this.methods, other.methods)) {
            return false;
        }
        if (!Objects.equals(this.initalizers, other.initalizers)) {
            return false;
        }
        if (!Objects.equals(this.classes, other.classes)) {
            return false;
        }
        return Objects.equals(this.modifiers, other.modifiers);
    }
}

