/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.model;

import com.speedment.common.codegen.internal.util.Copier;
import com.speedment.common.codegen.model.AnnotationUsage;
import com.speedment.common.codegen.model.Constructor;
import com.speedment.common.codegen.model.Field;
import com.speedment.common.codegen.model.Javadoc;
import com.speedment.common.codegen.model.modifier.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class ConstructorImpl
implements Constructor {
    private Javadoc javadoc;
    private final List<AnnotationUsage> annotations;
    private final List<Field> params;
    private final List<String> code;
    private final Set<Modifier> modifiers;
    private final Set<Type> exceptions;

    public ConstructorImpl() {
        this.javadoc = null;
        this.annotations = new ArrayList<AnnotationUsage>();
        this.params = new ArrayList<Field>();
        this.code = new ArrayList<String>();
        this.modifiers = new HashSet<Modifier>();
        this.exceptions = new HashSet<Type>();
    }

    protected ConstructorImpl(Constructor prototype) {
        this.javadoc = Objects.requireNonNull(prototype).getJavadoc().map(Copier::copy).orElse(null);
        this.annotations = Copier.copy(prototype.getAnnotations());
        this.params = Copier.copy(prototype.getFields());
        this.code = Copier.copy(prototype.getCode(), c -> c);
        this.modifiers = Copier.copy(prototype.getModifiers(), c -> c.copy(), EnumSet.noneOf(Modifier.class));
        this.exceptions = new LinkedHashSet<Type>(prototype.getExceptions());
    }

    @Override
    public List<Field> getFields() {
        return this.params;
    }

    @Override
    public List<String> getCode() {
        return this.code;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public Constructor set(Javadoc doc) {
        this.javadoc = doc;
        return this;
    }

    @Override
    public Optional<Javadoc> getJavadoc() {
        return Optional.ofNullable(this.javadoc);
    }

    @Override
    public List<AnnotationUsage> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Set<Type> getExceptions() {
        return this.exceptions;
    }

    @Override
    public ConstructorImpl copy() {
        return new ConstructorImpl(this);
    }

    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + Objects.hashCode(this.javadoc);
        hash = 43 * hash + Objects.hashCode(this.annotations);
        hash = 43 * hash + Objects.hashCode(this.params);
        hash = 43 * hash + Objects.hashCode(this.code);
        hash = 43 * hash + Objects.hashCode(this.modifiers);
        hash = 43 * hash + Objects.hashCode(this.exceptions);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstructorImpl other = (ConstructorImpl)obj;
        if (!Objects.equals(this.javadoc, other.javadoc)) {
            return false;
        }
        if (!Objects.equals(this.annotations, other.annotations)) {
            return false;
        }
        if (!Objects.equals(this.params, other.params)) {
            return false;
        }
        if (!Objects.equals(this.code, other.code)) {
            return false;
        }
        if (!Objects.equals(this.modifiers, other.modifiers)) {
            return false;
        }
        return Objects.equals(this.exceptions, other.exceptions);
    }
}

