/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.model;

import com.speedment.common.codegen.internal.util.Copier;
import com.speedment.common.codegen.model.EnumConstant;
import com.speedment.common.codegen.model.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class EnumConstantImpl
implements EnumConstant {
    private String name;
    private final List<Value<?>> values;

    public EnumConstantImpl(String name) {
        this.name = Objects.requireNonNull(name);
        this.values = new ArrayList();
    }

    protected EnumConstantImpl(EnumConstant prototype) {
        this.name = Objects.requireNonNull(prototype).getName();
        this.values = Copier.copy(prototype.getValues(), v -> (Value)v.copy());
    }

    @Override
    public EnumConstant setName(String name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Value<?>> getValues() {
        return this.values;
    }

    @Override
    public EnumConstantImpl copy() {
        return new EnumConstantImpl(this);
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + Objects.hashCode(this.name);
        hash = 37 * hash + Objects.hashCode(this.values);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumConstantImpl other = (EnumConstantImpl)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.values, other.values);
    }
}

