/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.model;

import com.speedment.common.codegen.internal.util.Copier;
import com.speedment.common.codegen.model.AnnotationUsage;
import com.speedment.common.codegen.model.Field;
import com.speedment.common.codegen.model.Javadoc;
import com.speedment.common.codegen.model.Value;
import com.speedment.common.codegen.model.modifier.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class FieldImpl
implements Field {
    private String name;
    private Type type;
    private Value<?> value;
    private Javadoc javadoc;
    private final List<AnnotationUsage> annotations;
    private final Set<Modifier> modifiers;

    public FieldImpl(String name, Type type) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.value = null;
        this.javadoc = null;
        this.annotations = new ArrayList<AnnotationUsage>();
        this.modifiers = EnumSet.noneOf(Modifier.class);
    }

    protected FieldImpl(Field prototype) {
        this.name = Objects.requireNonNull(prototype).getName();
        this.type = prototype.getType();
        this.value = prototype.getValue().map(Copier::copy).orElse(null);
        this.javadoc = prototype.getJavadoc().map(Copier::copy).orElse(null);
        this.annotations = Copier.copy(prototype.getAnnotations());
        this.modifiers = Copier.copy(prototype.getModifiers(), c -> c.copy(), EnumSet.noneOf(Modifier.class));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Field setName(String name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Field set(Type type) {
        this.type = Objects.requireNonNull(type);
        return this;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public Field set(Javadoc doc) {
        this.javadoc = doc;
        return this;
    }

    @Override
    public Optional<Javadoc> getJavadoc() {
        return Optional.ofNullable(this.javadoc);
    }

    @Override
    public Field set(Value<?> val) {
        this.value = val;
        return this;
    }

    @Override
    public Optional<Value<?>> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public List<AnnotationUsage> getAnnotations() {
        return this.annotations;
    }

    @Override
    public FieldImpl copy() {
        return new FieldImpl(this);
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + Objects.hashCode(this.name);
        hash = 29 * hash + Objects.hashCode(this.type);
        hash = 29 * hash + Objects.hashCode(this.value);
        hash = 29 * hash + Objects.hashCode(this.javadoc);
        hash = 29 * hash + Objects.hashCode(this.annotations);
        hash = 29 * hash + Objects.hashCode(this.modifiers);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldImpl other = (FieldImpl)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        if (!Objects.equals(this.javadoc, other.javadoc)) {
            return false;
        }
        if (!Objects.equals(this.annotations, other.annotations)) {
            return false;
        }
        return Objects.equals(this.modifiers, other.modifiers);
    }
}

