/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.model;

import com.speedment.common.codegen.internal.util.Copier;
import com.speedment.common.codegen.model.Import;
import com.speedment.common.codegen.model.modifier.Modifier;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class ImportImpl
implements Import {
    private Type type;
    private String staticMember;
    private final Set<Modifier> modifiers;

    public ImportImpl(Type type) {
        this.type = Objects.requireNonNull(type);
        this.staticMember = null;
        this.modifiers = EnumSet.noneOf(Modifier.class);
    }

    protected ImportImpl(Import prototype) {
        this.type = prototype.getType();
        this.modifiers = Copier.copy(prototype.getModifiers(), c -> c.copy(), EnumSet.noneOf(Modifier.class));
    }

    @Override
    public Import set(Type type) {
        this.type = Objects.requireNonNull(type);
        return this;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public Optional<String> getStaticMember() {
        return Optional.ofNullable(this.staticMember);
    }

    @Override
    public Import setStaticMember(String member) {
        this.staticMember = member;
        return this;
    }

    @Override
    public ImportImpl copy() {
        return new ImportImpl(this);
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.type);
        hash = 29 * hash + Objects.hashCode(this.staticMember);
        hash = 29 * hash + Objects.hashCode(this.modifiers);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImportImpl other = (ImportImpl)obj;
        if (!Objects.equals(this.staticMember, other.staticMember)) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        return Objects.equals(this.modifiers, other.modifiers);
    }
}

