/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.model;

import com.speedment.common.codegen.internal.util.Copier;
import com.speedment.common.codegen.model.Initializer;
import com.speedment.common.codegen.model.modifier.Modifier;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class InitializerImpl
implements Initializer {
    private final List<String> code;
    private final Set<Modifier> modifiers;

    public InitializerImpl() {
        this.code = new ArrayList<String>();
        this.modifiers = EnumSet.noneOf(Modifier.class);
    }

    protected InitializerImpl(Initializer prototype) {
        Objects.requireNonNull(prototype);
        this.code = Copier.copy(prototype.getCode(), c -> c);
        this.modifiers = Copier.copy(prototype.getModifiers(), c -> c);
    }

    @Override
    public List<String> getCode() {
        return this.code;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public InitializerImpl copy() {
        return new InitializerImpl(this);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.code);
        hash = 67 * hash + Objects.hashCode(this.modifiers);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InitializerImpl other = (InitializerImpl)obj;
        if (!Objects.equals(this.code, other.code)) {
            return false;
        }
        return Objects.equals(this.modifiers, other.modifiers);
    }
}

